/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUsub8Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String diff1 = environment.getNextVariableString();
        String diff2 = environment.getNextVariableString();
        String diff3 = environment.getNextVariableString();
        String diff4 = environment.getNextVariableString();
        String tmpRm15to8 = environment.getNextVariableString();
        String tmpRm23to16 = environment.getNextVariableString();
        String tmpRm31to24 = environment.getNextVariableString();
        String tmpRm7to0 = environment.getNextVariableString();
        String tmpRn15to8 = environment.getNextVariableString();
        String tmpRn23to16 = environment.getNextVariableString();
        String tmpRn31to24 = environment.getNextVariableString();
        String tmpRn7to0 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(255L), dw, tmpRn7to0));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(65280L), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(-8), dw, tmpRn15to8));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(0xFF0000L), dw, tmpVar2));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar2, dw, String.valueOf(-16), dw, tmpRn23to16));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(0xFF000000L), dw, tmpVar3));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar3, dw, String.valueOf(-24), dw, tmpRn31to24));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister2, dw, String.valueOf(255L), dw, tmpRm7to0));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister2, dw, String.valueOf(65280L), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(-8), dw, tmpRm15to8));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister2, dw, String.valueOf(0xFF0000L), dw, tmpVar2));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar2, dw, String.valueOf(-16), dw, tmpRm23to16));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister2, dw, String.valueOf(0xFF000000L), dw, tmpVar3));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar3, dw, String.valueOf(-24), dw, tmpRm31to24));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpRn7to0, dw, tmpRm7to0, dw, diff1));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpRn15to8, dw, tmpRm15to8, dw, diff2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpRn23to16, dw, tmpRm23to16, dw, diff3));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpRn31to24, dw, tmpRm31to24, dw, diff4));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, diff1, wd, String.valueOf(-7), bt2, "CPSR_GE_0"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, diff2, wd, String.valueOf(-7), bt2, "CPSR_GE_1"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, diff3, wd, String.valueOf(-7), bt2, "CPSR_GE_2"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, diff4, wd, String.valueOf(-7), bt2, "CPSR_GE_3"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, diff2, dw, String.valueOf(8), dw, diff2));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, diff3, dw, String.valueOf(16), dw, diff3));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, diff4, dw, String.valueOf(24), dw, diff4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, diff1, dw, String.valueOf(255L), dw, diff1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, diff2, dw, String.valueOf(65280L), dw, diff2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, diff3, dw, String.valueOf(0xFF0000L), dw, diff3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, diff4, dw, String.valueOf(0xFF000000L), dw, diff4));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, diff1, dw, diff2, dw, tmpVar4));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, diff3, dw, diff4, dw, tmpVar5));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar4, dw, tmpVar5, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "USUB8");
        this.translateAll(environment, instruction, "USUB8", instructions);
    }
}

