/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUqsub16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String tmpResult = environment.getNextVariableString();
        String tmpRm15to0 = environment.getNextVariableString();
        String tmpRm31to16 = environment.getNextVariableString();
        String tmpRn15to0 = environment.getNextVariableString();
        String tmpRn31to16 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar1Sat = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar3Sat = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(65535L), dw, tmpRn15to0));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister2, dw, String.valueOf(65535L), dw, tmpRm15to0));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpRn15to0, dw, tmpRm15to0, dw, tmpVar1));
        Helpers.unsignedSat(baseOffset, environment, instruction, instructions, tmpRn15to0, tmpRm15to0, tmpVar1, "SUB", tmpVar1Sat, 16L, "");
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, dw, String.valueOf(-16), dw, tmpRn31to16));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, dw, String.valueOf(-16), dw, tmpRm31to16));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpRn31to16, dw, tmpRm31to16, dw, tmpVar3));
        Helpers.unsignedSat(baseOffset, environment, instruction, instructions, tmpRn31to16, tmpRm31to16, tmpVar3, "SUB", tmpVar3Sat, 16L, "");
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar3Sat, dw, String.valueOf(16L), dw, tmpResult));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpResult, dw, tmpVar1Sat, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UQSUB16");
        this.translateAll(environment, instruction, "UQSUB16", instructions);
    }
}

