/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUqaddsubxTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String andedRm = environment.getNextVariableString();
        String andedRn = environment.getNextVariableString();
        String highResult = environment.getNextVariableString();
        String lowResult = environment.getNextVariableString();
        String shiftedRm = environment.getNextVariableString();
        String shiftedRn = environment.getNextVariableString();
        String tmpHighResult = environment.getNextVariableString();
        String tmpLowResult = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, dw, String.valueOf(-16), dw, shiftedRn));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister2, dw, String.valueOf(65535L), dw, andedRm));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, shiftedRn, dw, andedRm, dw, tmpHighResult));
        Helpers.unsignedSat(baseOffset, environment, instruction, instructions, shiftedRn, andedRm, tmpHighResult, "ADD", highResult, 16L, "");
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(65535L), dw, andedRn));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, dw, String.valueOf(-16), dw, shiftedRm));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, andedRn, dw, shiftedRm, dw, tmpLowResult));
        Helpers.unsignedSat(baseOffset, environment, instruction, instructions, andedRn, shiftedRm, tmpLowResult, "SUB", lowResult, 16L, "");
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, highResult, dw, String.valueOf(16), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, lowResult, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        if (instruction.getMnemonic().startsWith("UQASX")) {
            TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UQASX");
            this.translateAll(environment, instruction, "UQASX", instructions);
        } else {
            TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UQADDSUBX");
            this.translateAll(environment, instruction, "UQADDSUBX", instructions);
        }
    }
}

