/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUqadd8Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, final IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        String addOperation = "ADD";
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        new Processor(){

            @Override
            protected String[] process(long offset, String[] firstFour, String[] secondFour) {
                String sum1 = environment.getNextVariableString();
                String sum2 = environment.getNextVariableString();
                String sum3 = environment.getNextVariableString();
                String sum4 = environment.getNextVariableString();
                String sum1Sat = environment.getNextVariableString();
                String sum2Sat = environment.getNextVariableString();
                String sum3Sat = environment.getNextVariableString();
                String sum4Sat = environment.getNextVariableString();
                long baseOffset = offset;
                String usignedDoesSat = environment.getNextVariableString();
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstFour[0], dw, secondFour[0], dw, sum1));
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstFour[1], dw, secondFour[1], dw, sum2));
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstFour[2], dw, secondFour[2], dw, sum3));
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstFour[3], dw, secondFour[3], dw, sum4));
                Helpers.unsignedSat(baseOffset, environment, instruction, instructions, firstFour[0], secondFour[0], sum1, "ADD", sum1Sat, 8L, usignedDoesSat);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.unsignedSat(baseOffset, environment, instruction, instructions, firstFour[1], secondFour[1], sum2, "ADD", sum2Sat, 8L, usignedDoesSat);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.unsignedSat(baseOffset, environment, instruction, instructions, firstFour[2], secondFour[2], sum3, "ADD", sum3Sat, 8L, usignedDoesSat);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.unsignedSat(baseOffset, environment, instruction, instructions, firstFour[3], secondFour[3], sum4, "ADD", sum4Sat, 8L, usignedDoesSat);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                return new String[]{sum1Sat, sum2Sat, sum3Sat, sum4Sat};
            }
        }.generate(environment, baseOffset, 8, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UQADD8");
        this.translateAll(environment, instruction, "UQADD8", instructions);
    }
}

