/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUmlalTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String sourceRegister2 = registerOperand2.getValue();
        String sourceRegister3 = registerOperand3.getValue();
        String sourceRegister4 = registerOperand4.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpCarry = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        String tmpVar6 = environment.getNextVariableString();
        String tmpVar7 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createMul(baseOffset++, dw, sourceRegister3, dw, sourceRegister4, qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, String.valueOf(0xFFFFFFFFL), dw, tmpVar2));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpVar2, dw, sourceRegister1, qw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar3, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar3, wd, String.valueOf(-32L), bt2, tmpCarry));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpCarry, bt2, String.valueOf(1), bt2, tmpVar6));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar1, wd, String.valueOf(-32), dw, tmpVar4));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpVar4, dw, sourceRegister2, dw, tmpVar5));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpVar5, bt2, tmpVar6, dw, tmpVar7));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar7, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister2));
        if (instruction.getMnemonic().endsWith("S") && instruction.getMnemonic().length() != 7) {
            String isZero1 = environment.getNextVariableString();
            String isZero2 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, wd, String.valueOf(-31L), bt2, "N"));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister1, bt2, isZero1));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister2, bt2, isZero2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, isZero1, bt2, isZero2, bt2, "Z"));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UMLAL");
        this.translateAll(environment, instruction, "UMLAL", instructions);
    }
}

