/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUhsub8Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        final OperandSize wd = OperandSize.WORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        new Processor(){

            @Override
            protected int getResultShiftDelta() {
                return -1;
            }

            @Override
            protected String[] process(long offset, String[] firstFour, String[] secondFour) {
                String diff1 = environment.getNextVariableString();
                String diff2 = environment.getNextVariableString();
                String diff3 = environment.getNextVariableString();
                String diff4 = environment.getNextVariableString();
                long baseOffset = offset;
                instructions.add(ReilHelpers.createSub(baseOffset++, wd, firstFour[0], wd, secondFour[0], dw, diff1));
                instructions.add(ReilHelpers.createSub(baseOffset++, wd, firstFour[1], wd, secondFour[1], dw, diff2));
                instructions.add(ReilHelpers.createSub(baseOffset++, wd, firstFour[2], wd, secondFour[2], dw, diff3));
                instructions.add(ReilHelpers.createSub(baseOffset++, wd, firstFour[3], wd, secondFour[3], dw, diff4));
                return new String[]{diff1, diff2, diff3, diff4};
            }
        }.generate(environment, baseOffset, 8, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UHSUB8");
        this.translateAll(environment, instruction, "UHSUB8", instructions);
    }
}

