/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUhadd16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String tmpResult = environment.getNextVariableString();
        String tmpRm15to0 = environment.getNextVariableString();
        String tmpRm31to16 = environment.getNextVariableString();
        String tmpRn15to0 = environment.getNextVariableString();
        String tmpRn31to16 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar1Safe = environment.getNextVariableString();
        String tmpVar1SafeShifted = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar3Safe = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(65535L), dw, tmpRn15to0));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister2, dw, String.valueOf(65535L), dw, tmpRm15to0));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpRn15to0, dw, tmpRm15to0, dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(131070L), dw, tmpVar1Safe));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1Safe, bt2, String.valueOf(-1L), dw, tmpVar1SafeShifted));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, dw, String.valueOf(-16), dw, tmpRn31to16));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, dw, String.valueOf(-16), dw, tmpRm31to16));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpRn31to16, dw, tmpRm31to16, dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar3, dw, String.valueOf(131070L), dw, tmpVar3Safe));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar3Safe, dw, String.valueOf(15), dw, tmpResult));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpResult, dw, tmpVar1SafeShifted, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UHADD16");
        this.translateAll(environment, instruction, "UHADD16", instructions);
    }
}

