/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class ARMUdivTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        long baseOffset;
        String destination = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String dividend = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        String divisor = instruction.getOperands().get(2).getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        long offset = baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createDiv(offset++, dw, dividend, dw, divisor, dw, destination));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UDIV");
        this.translateAll(environment, instruction, "UDIV", instructions);
    }
}

