/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUaddsubxTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String andedRm = environment.getNextVariableString();
        String shiftedRn = environment.getNextVariableString();
        String tmpHighResult = environment.getNextVariableString();
        String andedRn = environment.getNextVariableString();
        String shiftedRm = environment.getNextVariableString();
        String tmpLowResult = environment.getNextVariableString();
        String highResult = environment.getNextVariableString();
        String lowResult = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, dw, String.valueOf(-16), dw, shiftedRn));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister2, dw, String.valueOf(65535L), dw, andedRm));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, shiftedRn, dw, andedRm, dw, tmpHighResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpHighResult, dw, String.valueOf(65535L), dw, highResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(65535L), dw, andedRn));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, dw, String.valueOf(-16), dw, shiftedRm));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, andedRn, dw, shiftedRm, dw, tmpLowResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpLowResult, dw, String.valueOf(65535L), dw, lowResult));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, highResult, dw, String.valueOf(16), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, lowResult, dw, targetRegister));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpHighResult, wd, String.valueOf(-16L), bt2, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar2, bt2, String.valueOf(1L), bt2, "CPSR_GE_2"));
        instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "CPSR_GE_2", bt2, "CPSR_GE_3"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpHighResult, wd, String.valueOf(-15L), bt2, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar3, bt2, String.valueOf(1L), bt2, "CPSR_GE_0"));
        instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "CPSR_GE_0", bt2, "CPSR_GE_1"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        if (instruction.getMnemonic().startsWith("UASX")) {
            TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UASX");
            this.translateAll(environment, instruction, "UASX", instructions);
        } else {
            TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UADDSUBX");
            this.translateAll(environment, instruction, "UADDSUBX", instructions);
        }
    }
}

