/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUadd8Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        final OperandSize bt2 = OperandSize.BYTE;
        final OperandSize wd = OperandSize.WORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        new Processor(){

            @Override
            protected String[] process(long offset, String[] firstFour, String[] secondFour) {
                String sum1 = environment.getNextVariableString();
                String sum2 = environment.getNextVariableString();
                String sum3 = environment.getNextVariableString();
                String sum4 = environment.getNextVariableString();
                long baseOffset = offset;
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstFour[0], dw, secondFour[0], dw, sum1));
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstFour[1], dw, secondFour[1], dw, sum2));
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstFour[2], dw, secondFour[2], dw, sum3));
                instructions.add(ReilHelpers.createAdd(baseOffset, dw, firstFour[3], dw, secondFour[3], dw, sum4));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sum1, wd, String.valueOf(-8), bt2, "CPSR_GE_0"));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sum2, wd, String.valueOf(-8), bt2, "CPSR_GE_1"));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sum3, wd, String.valueOf(-8), bt2, "CPSR_GE_2"));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sum4, wd, String.valueOf(-8), bt2, "CPSR_GE_3"));
                return new String[]{sum1, sum2, sum3, sum4};
            }
        }.generate(environment, baseOffset, 8, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UADD8");
        this.translateAll(environment, instruction, "UADD8", instructions);
    }
}

