/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUadd16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        final OperandSize bt2 = OperandSize.BYTE;
        final OperandSize wd = OperandSize.WORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        new Processor(){

            @Override
            protected int getResultShiftDelta() {
                return 0;
            }

            @Override
            protected String[] process(long offset, String[] firstTwo, String[] secondTwo) {
                String sum1 = environment.getNextVariableString();
                String sum2 = environment.getNextVariableString();
                String tmpVar1 = environment.getNextVariableString();
                String tmpVar2 = environment.getNextVariableString();
                long baseOffset = offset;
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstTwo[0], dw, secondTwo[0], dw, sum1));
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstTwo[1], dw, secondTwo[1], dw, sum2));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sum1, wd, String.valueOf(-16L), bt2, tmpVar1));
                instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar1, dw, String.valueOf(1L), bt2, "CPSR_GE_0"));
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "CPSR_GE_0", bt2, "CPSR_GE_1"));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sum2, wd, String.valueOf(-16L), bt2, tmpVar2));
                instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar2, dw, String.valueOf(1L), bt2, "CPSR_GE_2"));
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "CPSR_GE_2", bt2, "CPSR_GE_3"));
                return new String[]{sum1, sum2};
            }
        }.generate(environment, baseOffset, 16, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UADD16");
        this.translateAll(environment, instruction, "UADD16", instructions);
    }
}

