/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class ARMUBFXTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        String operand = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        Integer lsb = Integer.parseInt(instruction.getOperands().get(2).getRootNode().getChildren().get(0).getValue());
        Integer width = Integer.parseInt(instruction.getOperands().get(3).getRootNode().getChildren().get(0).getValue());
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Integer msb = lsb + width - 1;
        if (msb <= 31) {
            long mask = TranslationHelpers.generateOneMask(lsb, width, OperandSize.DWORD);
            String tempVar1 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, operand, dw, String.valueOf(mask), dw, tempVar1));
        } else {
            instructions.add(ReilHelpers.createUnknown(baseOffset++));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UBFX");
        this.translateAll(environment, instruction, "UBFX", instructions);
    }
}

