/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMSxtb16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode shifter = instruction.getOperands().get(1).getRootNode();
        String targetRegister = registerOperand1.getValue();
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String tmpVar1 = environment.getNextVariableString();
        String highResult = environment.getNextVariableString();
        String lowResult = environment.getNextVariableString();
        String tmpOperand2from23to16 = environment.getNextVariableString();
        String tmpOperand2from23to16signExtended = environment.getNextVariableString();
        String tmpOperand2from7to0 = environment.getNextVariableString();
        String tmpOperand2from7to0signExtended = environment.getNextVariableString();
        String tmpOperand2Shifted = environment.getNextVariableString();
        Pair<String, String> shifterPair = AddressingModeOneGenerator.generate(baseOffset, environment, instruction, instructions, shifter);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String shifterOperand = shifterPair.first();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, shifterOperand, wd, String.valueOf(255L), dw, tmpOperand2from7to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, shifterOperand, wd, String.valueOf(-16L), dw, tmpOperand2Shifted));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpOperand2Shifted, wd, String.valueOf(255L), dw, tmpOperand2from23to16));
        Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpOperand2from7to0, dw, tmpOperand2from7to0signExtended, 8);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpOperand2from23to16, dw, tmpOperand2from23to16signExtended, 8);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpOperand2from7to0signExtended, dw, String.valueOf(65535L), wd, lowResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpOperand2from23to16signExtended, dw, String.valueOf(65535L), wd, highResult));
        instructions.add(ReilHelpers.createBsh(baseOffset++, wd, highResult, wd, String.valueOf(16L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, lowResult, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SXTB16");
        this.translateAll(environment, instruction, "SXTB16", instructions);
    }
}

