/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSwpTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0).getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String memoryRegister2 = registerOperand3.getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String negRotVal2 = environment.getNextVariableString();
        String rotVal1 = environment.getNextVariableString();
        String rotVal2 = environment.getNextVariableString();
        String tmpResult = environment.getNextVariableString();
        String tmpRotate1 = environment.getNextVariableString();
        String tmpRotate2 = environment.getNextVariableString();
        String tmpVal1 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createLdm(baseOffset++, dw, memoryRegister2, dw, tmpVal1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, memoryRegister2, dw, String.valueOf(3), dw, rotVal1));
        instructions.add(ReilHelpers.createMul(baseOffset++, dw, rotVal1, dw, String.valueOf(8), dw, rotVal2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), dw, rotVal2, dw, negRotVal2));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVal1, dw, negRotVal2, dw, tmpRotate1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVal1, dw, rotVal2, dw, tmpRotate2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpRotate1, dw, tmpRotate2, dw, tmpResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpResult, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        instructions.add(ReilHelpers.createStm(baseOffset++, dw, sourceRegister1, dw, memoryRegister2));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SWP");
        this.translateAll(environment, instruction, "SWP", instructions);
    }
}

