/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMSsatTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode shifter = instruction.getOperands().get(2).getRootNode();
        String targetRegister = registerOperand1.getValue();
        String sourceImmediate = registerOperand2.getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Pair<String, String> shifterPair = AddressingModeOneGenerator.generate(baseOffset, environment, instruction, instructions, shifter);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String shifterOperand = shifterPair.first();
        Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, shifterOperand, dw, shifterOperand, dw, shifterOperand, "SSAT", targetRegister, Integer.decode(sourceImmediate).intValue(), "Q");
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SSAT");
        this.translateAll(environment, instruction, "SSAT", instructions);
    }
}

