/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSsat16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceImmediate = registerOperand2.getValue();
        String sourceRegister = registerOperand3.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String signedDoesSat1 = environment.getNextVariableString();
        String signedDoesSat2 = environment.getNextVariableString();
        String tmpResultHigh = environment.getNextVariableString();
        String tmpResultLow = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister, dw, String.valueOf(65535L), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, wd, String.valueOf(-16L), dw, tmpVar2));
        Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, tmpVar1, dw, tmpVar1, "", tmpResultLow, Integer.decode(sourceImmediate).intValue(), signedDoesSat1);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, tmpVar2, dw, tmpVar2, dw, tmpVar2, "", tmpResultHigh, Integer.decode(sourceImmediate).intValue(), signedDoesSat2);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpResultHigh, dw, String.valueOf(65535L), dw, tmpResultHigh));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpResultLow, dw, String.valueOf(65535L), dw, tmpResultLow));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpResultHigh, wd, String.valueOf(16L), dw, tmpVar3));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpResultLow, dw, tmpVar3, dw, targetRegister));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, signedDoesSat1, bt2, signedDoesSat2, bt2, "Q"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SSAT16");
        this.translateAll(environment, instruction, "SSAT16", instructions);
    }
}

