/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmullTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String sourceRegister2 = registerOperand2.getValue();
        String sourceRegister3 = registerOperand3.getValue();
        String sourceRegister4 = registerOperand4.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String isZeroCondition1 = environment.getNextVariableString();
        String isZeroCondition2 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String trueTmpResult = environment.getNextVariableString();
        Helpers.signedMul(baseOffset, environment, instruction, instructions, dw, sourceRegister3, dw, sourceRegister4, qw, trueTmpResult);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, trueTmpResult, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, trueTmpResult, wd, String.valueOf(-32L), dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister2));
        if (instruction.getMnemonic().endsWith("S") && instruction.getMnemonic().length() != 7) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, wd, String.valueOf(-31L), bt2, "N"));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister1, bt2, isZeroCondition1));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister2, bt2, isZeroCondition2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, isZeroCondition1, bt2, isZeroCondition2, bt2, "Z"));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMULL");
        this.translateAll(environment, instruction, "SMULL", instructions);
    }
}

