/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmmlsTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        String sourceRegister3 = registerOperand4.getValue();
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String value = environment.getNextVariableString();
        Helpers.signedMul(baseOffset, environment, instruction, instructions, dw, sourceRegister1, dw, sourceRegister2, qw, value);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister3, dw, String.valueOf(32L), qw, tmpVar1));
        if (instruction.getMnemonic().contains("R")) {
            instructions.add(ReilHelpers.createSub(baseOffset++, qw, tmpVar1, qw, value, qw, tmpVar2));
            instructions.add(ReilHelpers.createAdd(baseOffset++, qw, tmpVar2, dw, String.valueOf(0x80000000L), qw, tmpVar3));
        } else {
            instructions.add(ReilHelpers.createSub(baseOffset++, qw, tmpVar1, qw, value, qw, tmpVar3));
        }
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar3, wd, String.valueOf(-32L), dw, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar4, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMMLS");
        this.translateAll(environment, instruction, "SMMLS", instructions);
    }
}

