/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmlalXYTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String sourceRegister2 = registerOperand2.getValue();
        String sourceRegister3 = registerOperand3.getValue();
        String sourceRegister4 = registerOperand4.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String carryBit = environment.getNextVariableString();
        String operand1 = environment.getNextVariableString();
        String operand2 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        String tmpVar6 = environment.getNextVariableString();
        String tmpVar7 = environment.getNextVariableString();
        String tmpVar8 = environment.getNextVariableString();
        String tmpVar9 = environment.getNextVariableString();
        String isLessCondition = environment.getNextVariableString();
        if (instruction.getMnemonic().contains("BB")) {
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister3, dw, operand1, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister4, dw, operand2, 16);
        } else if (instruction.getMnemonic().contains("BT")) {
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister3, dw, operand1, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister4, wd, String.valueOf(-16L), dw, tmpVar1));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, operand2, 16);
        } else if (instruction.getMnemonic().contains("TB")) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister3, wd, String.valueOf(-16L), dw, tmpVar1));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, operand1, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister4, dw, operand2, 16);
        } else if (instruction.getMnemonic().contains("TB")) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister3, wd, String.valueOf(-16L), dw, tmpVar1));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, operand1, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister4, wd, String.valueOf(-16L), dw, tmpVar2));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar2, dw, operand2, 16);
        }
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createMul(baseOffset++, dw, operand1, dw, operand2, qw, tmpVar3));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister1, qw, tmpVar3, qw, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar4, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar3, wd, String.valueOf(-31L), bt2, tmpVar5));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar5, bt2, String.valueOf(1L), bt2, isLessCondition));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0L), bt2, isLessCondition, dw, tmpVar6));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar3, wd, String.valueOf(-32L), bt2, tmpVar7));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar7, bt2, String.valueOf(1L), bt2, carryBit));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpVar6, bt2, carryBit, dw, tmpVar8));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister2, dw, tmpVar8, dw, tmpVar9));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar9, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister2));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMLAL");
        this.translateAll(environment, instruction, "SMLAL", instructions);
    }
}

