/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmlalTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String sourceRegister2 = registerOperand2.getValue();
        String sourceRegister3 = registerOperand3.getValue();
        String sourceRegister4 = registerOperand4.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String firstZero = environment.getNextVariableString();
        String secondZero = environment.getNextVariableString();
        String tmpCarry = environment.getNextVariableString();
        String tmpResult1 = environment.getNextVariableString();
        String tmpResult2 = environment.getNextVariableString();
        String tmpResult3 = environment.getNextVariableString();
        String tmpResult4 = environment.getNextVariableString();
        String trueCarry = environment.getNextVariableString();
        String tmpResult = environment.getNextVariableString();
        Helpers.signedMul(baseOffset, environment, instruction, instructions, dw, sourceRegister3, dw, sourceRegister4, qw, tmpResult);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAdd(baseOffset++, qw, tmpResult, dw, sourceRegister1, qw, tmpResult1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpResult1, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpResult1, wd, String.valueOf(-32), bt2, tmpCarry));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpCarry, bt2, String.valueOf(1L), bt2, trueCarry));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpResult, dw, String.valueOf(-32L), dw, tmpResult2));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpResult2, bt2, trueCarry, qw, tmpResult3));
        instructions.add(ReilHelpers.createAdd(baseOffset++, qw, tmpResult3, dw, sourceRegister2, qw, tmpResult4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpResult4, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister2));
        if (instruction.getMnemonic().endsWith("S") && instruction.getMnemonic().length() != 7) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, wd, String.valueOf(-31), bt2, "N"));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister2, bt2, firstZero));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister1, bt2, secondZero));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, firstZero, bt2, secondZero, bt2, "Z"));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMLAL");
        this.translateAll(environment, instruction, "SMLAL", instructions);
    }
}

