/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMShsub8Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, final IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        new Processor(){

            @Override
            protected int getResultShiftDelta() {
                return -1;
            }

            @Override
            protected String[] process(long offset, String[] firstFour, String[] secondFour) {
                String diff1 = environment.getNextVariableString();
                String diff2 = environment.getNextVariableString();
                String diff3 = environment.getNextVariableString();
                String diff4 = environment.getNextVariableString();
                String trueDiff1 = environment.getNextVariableString();
                String trueDiff2 = environment.getNextVariableString();
                String trueDiff3 = environment.getNextVariableString();
                String trueDiff4 = environment.getNextVariableString();
                long baseOffset = offset;
                Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, firstFour[0], dw, firstFour[0], 8);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, firstFour[1], dw, firstFour[1], 8);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, firstFour[2], dw, firstFour[2], 8);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, firstFour[3], dw, firstFour[3], 8);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, secondFour[0], dw, secondFour[0], 8);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, secondFour[1], dw, secondFour[1], 8);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, secondFour[2], dw, secondFour[2], 8);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, secondFour[3], dw, secondFour[3], 8);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondFour[0], firstFour[0], diff1, trueDiff1);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondFour[1], firstFour[1], diff2, trueDiff2);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondFour[2], firstFour[2], diff3, trueDiff3);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondFour[3], firstFour[3], diff4, trueDiff4);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                return new String[]{diff1, diff2, diff3, diff4};
            }
        }.generate(environment, baseOffset, 8, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SHSUB8");
        this.translateAll(environment, instruction, "SHSUB8", instructions);
    }
}

