/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.mips.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMSdivTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        String destination = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String dividend = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        String divisor = instruction.getOperands().get(2).getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Pair<String, String> sourceRegister1Abs = Helpers.generateAbs(environment, baseOffset, dividend, dw, instructions);
        String sourceRegister1Absolute = sourceRegister1Abs.second();
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Pair<String, String> sourceRegister2Abs = Helpers.generateAbs(environment, baseOffset, divisor, dw, instructions);
        String sourceRegister2Absolute = sourceRegister2Abs.second();
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String divResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createDiv(baseOffset++, dw, sourceRegister1Absolute, dw, sourceRegister2Absolute, dw, divResult));
        String xoredSigns = environment.getNextVariableString();
        String divToggleMask = environment.getNextVariableString();
        String xoredDivResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(baseOffset++, dw, sourceRegister1Abs.first(), dw, sourceRegister2Abs.first(), dw, xoredSigns));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0L), dw, xoredSigns, dw, divToggleMask));
        instructions.add(ReilHelpers.createXor(baseOffset++, dw, divToggleMask, dw, divResult, dw, xoredDivResult));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, xoredDivResult, dw, xoredSigns, dw, destination));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "ORN");
        this.translateAll(environment, instruction, "ORN", instructions);
    }
}

