/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMSbcTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode shifter = instruction.getOperands().get(2).getRootNode();
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String notCFlag = environment.getNextVariableString();
        Pair<String, String> shifterPair = AddressingModeOneGenerator.generate(baseOffset, environment, instruction, instructions, shifter);
        baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String shifterOperand = shifterPair.first();
        instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "C", bt2, notCFlag));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, sourceRegister, bt2, notCFlag, dw, tmpVar1));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar1, dw, shifterOperand, dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        if (instruction.getMnemonic().endsWith("S") && instruction.getMnemonic().length() != 5) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, targetRegister, wd, String.valueOf(-31), dw, "N"));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, targetRegister, bt2, "Z"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar2, wd, String.valueOf(-31L), bt2, tmpVar3));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar3, bt2, String.valueOf(1L), bt2, tmpVar4));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpVar4, bt2, "C"));
            Helpers.subOverflow(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, shifterOperand, dw, tmpVar2, "V", 32L);
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SBC");
        this.translateAll(environment, instruction, "SBC", instructions);
    }
}

