/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMQsub16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, final IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        new Processor(){

            @Override
            protected int getResultShiftDelta() {
                return 0;
            }

            @Override
            protected String[] process(long offset, String[] firstTwo, String[] secondTwo) {
                String sum1 = environment.getNextVariableString();
                String sum2 = environment.getNextVariableString();
                String sum1Sat = environment.getNextVariableString();
                String sum2Sat = environment.getNextVariableString();
                long baseOffset = offset;
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstTwo[0], dw, secondTwo[0], dw, sum1));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstTwo[1], dw, secondTwo[1], dw, sum2));
                Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, firstTwo[0], dw, secondTwo[0], dw, sum1, "SUB", sum1Sat, 16L, "");
                Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, firstTwo[1], dw, secondTwo[1], dw, sum2, "SUB", sum2Sat, 16L, "");
                return new String[]{sum1Sat, sum2Sat};
            }
        }.generate(environment, baseOffset, 16, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "QSUB16");
        this.translateAll(environment, instruction, "QSUB16", instructions);
    }
}

