/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMQdsubTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpRnTimesTwo = environment.getNextVariableString();
        String signedDoesSat1 = environment.getNextVariableString();
        String signedDoesSat2 = environment.getNextVariableString();
        String tmpResultVar1 = environment.getNextVariableString();
        String subtracted2RnRm = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister2, bt2, sourceRegister2, dw, tmpRnTimesTwo));
        Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, sourceRegister2, dw, sourceRegister2, dw, tmpRnTimesTwo, "ADD", tmpResultVar1, 32L, signedDoesSat1);
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, sourceRegister1, dw, tmpResultVar1, dw, subtracted2RnRm));
        Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, sourceRegister1, dw, tmpResultVar1, dw, subtracted2RnRm, "SUB", targetRegister, 32L, signedDoesSat2);
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, signedDoesSat1, bt2, signedDoesSat2, bt2, "Q"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "QDSUB");
        this.translateAll(environment, instruction, "QDSUB", instructions);
    }
}

