/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMOrrTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode shifter = instruction.getOperands().get(2).getRootNode();
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        Pair<String, String> shifterPair = AddressingModeOneGenerator.generate(baseOffset, environment, instruction, instructions, shifter);
        baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String shifterOperand = shifterPair.first();
        String shifterCarryOut = shifterPair.second();
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, sourceRegister, dw, shifterOperand, dw, targetRegister));
        if (instruction.getMnemonic().endsWith("S") && instruction.getMnemonic().length() != 5) {
            String tmpVar3 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, targetRegister, dw, String.valueOf(-31L), bt2, tmpVar3));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar3, bt2, String.valueOf(1L), bt2, "N"));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, targetRegister, bt2, "Z"));
            instructions.add(ReilHelpers.createStr(baseOffset++, bt2, shifterCarryOut, bt2, "C"));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "ORR");
        this.translateAll(environment, instruction, "ORR", instructions);
    }
}

