/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMMulTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String multRegister1 = registerOperand2.getValue();
        String multRegister2 = registerOperand3.getValue();
        String tmpVar1 = environment.getNextVariableString();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        instructions.add(ReilHelpers.createMul(baseOffset++, dw, multRegister1, dw, multRegister2, qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        if (instruction.getMnemonic().endsWith("S") && instruction.getMnemonic().length() != 5) {
            String tmpVar3 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, targetRegister, dw, String.valueOf(-31L), bt2, tmpVar3));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar3, bt2, String.valueOf(1L), bt2, "N"));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, targetRegister, bt2, "Z"));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "MUL");
        this.translateAll(environment, instruction, "MUL", instructions);
    }
}

