/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMBlxTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        String[] meta = new String[]{"isCall", "true"};
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        String jumpOperand = environment.getNextVariableString();
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, String.valueOf(instruction.getAddress().toLong() + 4L), dw, "LR"));
        if (registerOperand1.getType() == ExpressionType.REGISTER) {
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, bt2, String.valueOf(1), bt2, "T"));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(0xFFFFFFFEL), dw, jumpOperand));
        } else {
            instructions.add(ReilHelpers.createStr(baseOffset++, bt2, String.valueOf(1), bt2, "T"));
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, sourceRegister1, dw, jumpOperand));
        }
        instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, String.valueOf(1L), dw, jumpOperand, meta));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "BLX");
        this.translateAll(environment, instruction, "BLX", instructions);
    }
}

