/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMBlTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        String[] stringArray;
        if (instruction.getMnemonic().startsWith("BL")) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "isCall";
            stringArray = stringArray2;
            stringArray2[1] = "true";
        } else {
            stringArray = new String[]{};
        }
        String[] meta = stringArray;
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        if (instruction.getMnemonic().startsWith("BL")) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, String.valueOf(instruction.getAddress().toLong() + 4L), dw, "LR"));
        }
        instructions.add(ReilHelpers.createJcc(baseOffset++, dw, String.valueOf(1L), dw, sourceRegister1, meta));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "B");
        if (instruction.getMnemonic().startsWith("BL")) {
            this.translateAll(environment, instruction, "BL", instructions);
        } else {
            this.translateAll(environment, instruction, "B", instructions);
        }
    }
}

