/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.util.List;

public class TranslationResult {
    private List<ReilInstruction> instructions;
    private String register;
    private OperandSize size;
    private String address;
    private TranslationResultType type;
    private long baseAddress;

    public TranslationResult(String register2, OperandSize size, TranslationResultType type, String address, List<ReilInstruction> instructions, long baseAddress) {
        this.baseAddress = baseAddress;
        this.address = address;
        this.register = register2;
        this.size = size;
        this.type = type;
        this.instructions = instructions;
    }

    public String getAddress() {
        return this.address;
    }

    public List<ReilInstruction> getInstructions() {
        return this.instructions;
    }

    public String getRegister() {
        return this.register;
    }

    public OperandSize getSize() {
        return this.size;
    }

    public TranslationResultType getType() {
        return this.type;
    }

    public void updateResult(String result, OperandSize resultSize, String address, TranslationResultType type) {
        this.register = Preconditions.checkNotNull(result);
        this.size = Preconditions.checkNotNull(resultSize);
        this.type = Preconditions.checkNotNull(type);
        this.address = address;
    }

    public void updateBaseAndReil(long baseAddress, List<ReilInstruction> instructions) {
        this.instructions = instructions;
        this.baseAddress = baseAddress;
    }

    public void addInstruction(ReilInstruction instruction) {
        this.addInstructionWithDelta(instruction, 0L);
    }

    public void addInstructionWithDelta(ReilInstruction instruction, long delta) {
        instruction.setAddress(new CAddress(this.baseAddress + (long)this.instructions.size() + delta));
        this.instructions.add(instruction);
    }
}

