/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class TranslationHelpers {
    public static void checkTranslationArguments(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Argument environment cannot be null");
        Preconditions.checkNotNull(instruction, "Argument instruction cannot be null");
        Preconditions.checkNotNull(instructions, "Argument instructions cannot be null");
    }

    public static long generateOneMask(int lsb, int width, OperandSize size) {
        return TranslationHelpers.generateZeroMask(lsb, width, size) ^ TranslationHelpers.getAllBitsMask(size);
    }

    public static long generateZeroMask(int lsb, int width, OperandSize size) {
        Preconditions.checkNotNull(size, "Size argument can not be null");
        Preconditions.checkPositionIndex(lsb, size.getBitSize() - 1);
        Preconditions.checkArgument(width >= 1);
        Preconditions.checkPositionIndex(lsb + width - 1, size.getBitSize());
        long mask = TranslationHelpers.getAllBitsMask(size);
        long msb = lsb + width - 1;
        long xorBit = 1L;
        for (long i2 = (long)lsb; i2 <= msb; ++i2) {
            mask ^= 1L << (int)i2;
        }
        return mask & TranslationHelpers.getAllBitsMask(size);
    }

    public static long getAllBitsMask(OperandSize size) {
        switch (size) {
            case BYTE: {
                return 255L;
            }
            case WORD: {
                return 65535L;
            }
            case DWORD: {
                return 0xFFFFFFFFL;
            }
            case QWORD: {
                return -1L;
            }
        }
        throw new IllegalArgumentException("Error: Invalid argument size");
    }

    public static long getAllButMask(OperandSize largerSize, OperandSize smallerSize) {
        return TranslationHelpers.getAllBitsMask(largerSize) ^ TranslationHelpers.getAllBitsMask(smallerSize);
    }

    public static long getMsbMask(OperandSize size) {
        switch (size) {
            case BYTE: {
                return 128L;
            }
            case WORD: {
                return 32768L;
            }
            case DWORD: {
                return 0x80000000L;
            }
            case QWORD: {
                return Long.MIN_VALUE;
            }
        }
        throw new IllegalArgumentException("Error: Invalid argument size");
    }

    public static OperandSize getNextSize(OperandSize size) {
        switch (size) {
            case BYTE: {
                return OperandSize.WORD;
            }
            case WORD: {
                return OperandSize.DWORD;
            }
            case DWORD: {
                return OperandSize.QWORD;
            }
            case QWORD: {
                return OperandSize.OWORD;
            }
        }
        throw new IllegalArgumentException("Error: Invalid argument size");
    }

    public static long getShiftMsbLsbMask(OperandSize size) {
        return -(size.getBitSize() - 1);
    }

    public static boolean isSizeExpression(IOperandTreeNode expression) {
        return OperandSize.isSizeString(expression.getValue());
    }
}

