/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators;

import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilEdge;
import com.google.security.zynamics.reil.ReilGraph;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.BasicBlockGenerator;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.Triple;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReilGraphGenerator {
    public static ReilGraph createGraph(Collection<List<ReilInstruction>> instructionList, Collection<IAddress> nativeJumpTargets) {
        Pair<List<ReilBlock>, List<ReilEdge>> pair = ReilGraphGenerator.createGraphElements(instructionList, nativeJumpTargets);
        return new ReilGraph(pair.first(), pair.second());
    }

    public static Pair<List<ReilBlock>, List<ReilEdge>> createGraphElements(Collection<List<ReilInstruction>> instructionList, Collection<IAddress> nativeJumpTargets) {
        BasicBlockGenerator generator2 = new BasicBlockGenerator(instructionList, nativeJumpTargets);
        List<ReilBlock> blocks = generator2.getBlocks();
        ArrayList<Triple<ReilBlock, IAddress, EdgeType>> edgepairs = generator2.getEdges();
        ArrayList<ReilEdge> edges = new ArrayList<ReilEdge>();
        for (Triple<ReilBlock, IAddress, EdgeType> p2 : edgepairs) {
            ReilBlock source = p2.first();
            IAddress target = p2.second();
            EdgeType edgeType = p2.third();
            if (target != null) {
                for (ReilBlock block : blocks) {
                    for (ReilInstruction instruction : block.getInstructions()) {
                        if (!target.equals(instruction.getAddress())) continue;
                        ReilEdge edge = new ReilEdge(source, block, edgeType);
                        edges.add(edge);
                        ReilBlock.link(source, block, edge);
                    }
                }
                continue;
            }
            int index = blocks.indexOf(source);
            if (blocks.size() <= index + 1) continue;
            ReilEdge edge = new ReilEdge(source, blocks.get(index + 1), edgeType);
            edges.add(edge);
            ReilBlock.link(source, blocks.get(index + 1), edge);
        }
        return new Pair<List<ReilBlock>, List<ReilEdge>>(blocks, edges);
    }
}

