/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono2.registertracking;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.ReilFunction;
import com.google.security.zynamics.reil.algorithms.mono2.common.MonoReilSolver;
import com.google.security.zynamics.reil.algorithms.mono2.common.MonoReilSolverResult;
import com.google.security.zynamics.reil.algorithms.mono2.common.instructiongraph.interfaces.IInstructionGraphEdge;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterSetLattice;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterSetLatticeElement;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterTrackingOptions;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterTrackingTransformationProvider;
import com.google.security.zynamics.reil.yfileswrap.algorithms.mono2.common.instructiongraph.CReilInstructionGraph;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;

public final class RegisterTracker {
    private RegisterTracker() {
    }

    public static MonoReilSolverResult<RegisterSetLatticeElement> track(ReilFunction function, IInstruction startInstruction, String trackedRegister, RegisterTrackingOptions options) {
        Preconditions.checkNotNull(function, "Error: function argument can not be null");
        Preconditions.checkNotNull(startInstruction, "Error: startInstruction argument can not be null");
        Preconditions.checkNotNull(trackedRegister, "Error: trackedRegister argument can not be null");
        Preconditions.checkNotNull(options, "Error: options argument can not be null");
        CReilInstructionGraph instructionGraph = new CReilInstructionGraph(function.getGraph());
        RegisterSetLatticeElement registerSetLatticeElement = new RegisterSetLatticeElement(trackedRegister);
        MonoReilSolver<RegisterSetLatticeElement> monoReilSolver = new MonoReilSolver<RegisterSetLatticeElement>(instructionGraph, options.getAnalysisDirection(), new RegisterSetLattice());
        Iterable<IInstructionGraphEdge> relevantEdges = options.trackIncoming() ? instructionGraph.getIncomingEdgesForAddress(startInstruction.getAddress()) : instructionGraph.getOutgoingEdgesForAddress(startInstruction.getAddress());
        ArrayList initialState = new ArrayList();
        for (IInstructionGraphEdge currentRelevantEdge : relevantEdges) {
            initialState.add(new Pair<IInstructionGraphEdge, RegisterSetLatticeElement>(currentRelevantEdge, registerSetLatticeElement));
        }
        RegisterTrackingTransformationProvider transformationProvider = new RegisterTrackingTransformationProvider(options);
        MonoReilSolverResult<RegisterSetLatticeElement> solverResult = monoReilSolver.solve(transformationProvider, initialState, Integer.MAX_VALUE);
        return solverResult;
    }
}

