/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono2.registertracking;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.ILatticeElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class RegisterSetLatticeElement
implements ILatticeElement<RegisterSetLatticeElement> {
    private ImmutableSet<String> m_nativeNewlyTaintedRegs = ImmutableSet.builder().build();
    private ImmutableSet<String> m_nativeUntaintedRegs = ImmutableSet.builder().build();
    private ImmutableSet<String> m_nativeReadRegs = ImmutableSet.builder().build();
    private ImmutableSet<String> m_nativeUpdatedRegs = ImmutableSet.builder().build();
    private final Set<String> m_taintedRegs;
    private final Set<String> m_newlyTaintedRegs;
    private final Set<String> m_untaintedRegs;
    private final Set<String> m_readRegs;
    private final Set<String> m_updatedRegs;

    public RegisterSetLatticeElement() {
        this.m_taintedRegs = new TreeSet<String>();
        this.m_newlyTaintedRegs = new TreeSet<String>();
        this.m_untaintedRegs = new TreeSet<String>();
        this.m_readRegs = new TreeSet<String>();
        this.m_updatedRegs = new TreeSet<String>();
    }

    public RegisterSetLatticeElement(Set<String> taintedRegs, Set<String> newlyTaintedRegs, Set<String> untaintedRegs, Set<String> readRegs, Set<String> updatedRegs) {
        Preconditions.checkNotNull(taintedRegs, "Error: Tainted registers argument can not be null");
        Preconditions.checkNotNull(newlyTaintedRegs, "Error: Newly tainted registers argument can not be null");
        Preconditions.checkNotNull(untaintedRegs, "Error: Untainted registers argument can not be null");
        Preconditions.checkNotNull(readRegs, "Error: Read registers argument can not be null");
        Preconditions.checkNotNull(updatedRegs, "Error: Updated registers argument can not be null");
        this.m_taintedRegs = new TreeSet<String>(taintedRegs);
        this.m_newlyTaintedRegs = new TreeSet<String>(newlyTaintedRegs);
        this.m_untaintedRegs = new TreeSet<String>(untaintedRegs);
        this.m_readRegs = new TreeSet<String>(readRegs);
        this.m_updatedRegs = new TreeSet<String>(updatedRegs);
    }

    public RegisterSetLatticeElement(String register2) {
        Preconditions.checkNotNull(register2, "Error: Register argument can not be null");
        this.m_taintedRegs = new TreeSet<String>();
        this.m_taintedRegs.add(register2);
        this.m_newlyTaintedRegs = new TreeSet<String>();
        this.m_newlyTaintedRegs.add(register2);
        this.m_untaintedRegs = new TreeSet<String>();
        this.m_readRegs = new TreeSet<String>();
        this.m_updatedRegs = new TreeSet<String>();
    }

    private static void clearTemporaryRegisters(Set<String> registerSet) {
        Sets.filter(registerSet, new Predicate<String>(){

            @Override
            public boolean apply(String register2) {
                return ReilHelpers.isTemporaryRegister(register2);
            }
        }).clear();
    }

    public void addAll(Collection<RegisterSetLatticeElement> inputState) {
        Preconditions.checkNotNull(inputState, "Error: Input state argument can not be null");
        HashSet<String> tempNativeNewlyTaintedRegisters = Sets.newHashSet();
        HashSet<String> tempNativeUntaintedRegisters = Sets.newHashSet();
        HashSet<String> tempNativeReadRegisters = Sets.newHashSet();
        HashSet<String> tempNativeUpdatedRegisters = Sets.newHashSet();
        for (RegisterSetLatticeElement element : inputState) {
            tempNativeNewlyTaintedRegisters.addAll(element.m_nativeNewlyTaintedRegs);
            tempNativeUntaintedRegisters.addAll(element.m_nativeUntaintedRegs);
            tempNativeReadRegisters.addAll(element.m_nativeReadRegs);
            tempNativeUpdatedRegisters.addAll(element.m_nativeUpdatedRegs);
            this.m_taintedRegs.addAll(element.m_taintedRegs);
            this.m_newlyTaintedRegs.addAll(element.m_newlyTaintedRegs);
            this.m_untaintedRegs.addAll(element.m_untaintedRegs);
            this.m_readRegs.addAll(element.m_readRegs);
            this.m_updatedRegs.addAll(element.m_updatedRegs);
        }
        this.m_nativeNewlyTaintedRegs = ImmutableSet.copyOf(tempNativeNewlyTaintedRegisters);
        this.m_nativeUntaintedRegs = ImmutableSet.copyOf(tempNativeUntaintedRegisters);
        this.m_nativeReadRegs = ImmutableSet.copyOf(tempNativeReadRegisters);
        this.m_nativeUpdatedRegs = ImmutableSet.copyOf(tempNativeUpdatedRegisters);
    }

    public void addReadReg(String reg) {
        this.m_readRegs.add(Preconditions.checkNotNull(reg, "Error: Register argument can not be null"));
    }

    @Override
    public RegisterSetLatticeElement copy() {
        return new RegisterSetLatticeElement(this.m_taintedRegs, this.m_newlyTaintedRegs, this.m_untaintedRegs, this.m_readRegs, this.m_updatedRegs);
    }

    public Collection<String> getNewlyTaintedRegisters() {
        return Collections.unmodifiableCollection(this.m_nativeNewlyTaintedRegs);
    }

    public Collection<String> getReadRegisters() {
        return Collections.unmodifiableCollection(this.m_nativeReadRegs);
    }

    public Collection<String> getTaintedRegisters() {
        return Collections.unmodifiableCollection(this.m_taintedRegs);
    }

    public Collection<String> getUntaintedRegisters() {
        return Collections.unmodifiableCollection(this.m_nativeUntaintedRegs);
    }

    public Collection<String> getUpdatedRegisters() {
        return Collections.unmodifiableCollection(this.m_nativeUpdatedRegs);
    }

    public boolean isSmallerEqual(RegisterSetLatticeElement other) {
        Preconditions.checkNotNull(other, "Error: Other argument can not be null");
        boolean result = other.m_taintedRegs.containsAll(this.m_taintedRegs) && other.m_newlyTaintedRegs.containsAll(this.m_newlyTaintedRegs) && other.m_untaintedRegs.containsAll(this.m_untaintedRegs) && other.m_readRegs.containsAll(this.m_readRegs) && other.m_updatedRegs.containsAll(this.m_updatedRegs) && other.m_nativeNewlyTaintedRegs.containsAll(this.m_nativeNewlyTaintedRegs) && other.m_nativeReadRegs.containsAll(this.m_nativeReadRegs) && other.m_nativeUntaintedRegs.containsAll(this.m_nativeUntaintedRegs) && other.m_nativeUpdatedRegs.containsAll(this.m_nativeUpdatedRegs);
        return result;
    }

    public boolean isTainted(Collection<String> registers) {
        Preconditions.checkNotNull(registers, "Error: Registers argument can not be null");
        for (String register2 : registers) {
            if (!this.m_taintedRegs.contains(register2)) continue;
            return true;
        }
        return false;
    }

    public boolean isTainted(String register2) {
        return this.m_taintedRegs.contains(Preconditions.checkNotNull(register2, "Error: Register argument can not be null"));
    }

    @Override
    public void onInstructionExit() {
        RegisterSetLatticeElement.clearTemporaryRegisters(this.m_taintedRegs);
        RegisterSetLatticeElement.clearTemporaryRegisters(this.m_newlyTaintedRegs);
        RegisterSetLatticeElement.clearTemporaryRegisters(this.m_untaintedRegs);
        RegisterSetLatticeElement.clearTemporaryRegisters(this.m_readRegs);
        RegisterSetLatticeElement.clearTemporaryRegisters(this.m_updatedRegs);
        this.m_nativeNewlyTaintedRegs = ImmutableSet.copyOf(this.m_newlyTaintedRegs);
        this.m_nativeUntaintedRegs = ImmutableSet.copyOf(this.m_untaintedRegs);
        this.m_nativeReadRegs = ImmutableSet.copyOf(this.m_readRegs);
        this.m_nativeUpdatedRegs = ImmutableSet.copyOf(this.m_updatedRegs);
        this.m_newlyTaintedRegs.clear();
        this.m_untaintedRegs.clear();
        this.m_readRegs.clear();
        this.m_updatedRegs.clear();
    }

    public void taint(String register2) {
        Preconditions.checkNotNull(register2, "Error: Register argument can not be null");
        if (this.isTainted(register2) || this.m_untaintedRegs.contains(register2)) {
            this.m_updatedRegs.add(register2);
        } else {
            this.m_newlyTaintedRegs.add(register2);
        }
        this.m_taintedRegs.add(register2);
        this.m_untaintedRegs.remove(register2);
    }

    public void taintAll(Collection<String> registers) {
        Preconditions.checkNotNull(registers, "Error: State argument can not be null");
        for (String taintedRegister : registers) {
            this.taint(taintedRegister);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String string2 = String.valueOf(this.m_nativeNewlyTaintedRegs);
        builder.append(new StringBuilder(28 + String.valueOf(string2).length()).append("Preserved added registers: ").append(string2).append("\n").toString());
        string2 = String.valueOf(this.m_nativeUntaintedRegs);
        builder.append(new StringBuilder(32 + String.valueOf(string2).length()).append("Preserved untainted registers: ").append(string2).append("\n").toString());
        string2 = String.valueOf(this.m_nativeReadRegs);
        builder.append(new StringBuilder(27 + String.valueOf(string2).length()).append("Preserved read registers: ").append(string2).append("\n").toString());
        string2 = String.valueOf(this.m_nativeUpdatedRegs);
        builder.append(new StringBuilder(30 + String.valueOf(string2).length()).append("Preserved updated registers: ").append(string2).append("\n").toString());
        string2 = String.valueOf(this.m_taintedRegs);
        builder.append(new StringBuilder(20 + String.valueOf(string2).length()).append("Tainted registers: ").append(string2).append("\n").toString());
        string2 = String.valueOf(this.m_newlyTaintedRegs);
        builder.append(new StringBuilder(18 + String.valueOf(string2).length()).append("Added registers: ").append(string2).append("\n").toString());
        string2 = String.valueOf(this.m_untaintedRegs);
        builder.append(new StringBuilder(22 + String.valueOf(string2).length()).append("Untainted registers: ").append(string2).append("\n").toString());
        string2 = String.valueOf(this.m_readRegs);
        builder.append(new StringBuilder(17 + String.valueOf(string2).length()).append("Read registers: ").append(string2).append("\n").toString());
        string2 = String.valueOf(this.m_updatedRegs);
        builder.append(new StringBuilder(20 + String.valueOf(string2).length()).append("Updated registers: ").append(string2).append("\n").toString());
        return builder.toString();
    }

    public void untaint(String register2) {
        Preconditions.checkNotNull(register2, "Error: Register argument can not be null");
        if (this.isTainted(register2)) {
            this.m_untaintedRegs.add(register2);
            this.m_taintedRegs.remove(register2);
        }
    }

    public void untaintAll(Collection<String> registers) {
        Preconditions.checkNotNull(registers, "Error: Registers argument can not be null");
        for (String register2 : registers) {
            this.untaint(register2);
        }
    }
}

