/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono2.common;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono2.common.instructiongraph.interfaces.IInstructionGraphNode;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.ILatticeElement;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.ITransformationProvider;
import com.google.security.zynamics.zylib.general.Pair;

public abstract class PerInstructionTransformationProvider<LatticeElementType extends ILatticeElement<LatticeElementType>>
implements ITransformationProvider<LatticeElementType> {
    protected abstract Pair<LatticeElementType, LatticeElementType> transformAdd(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformAnd(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformBisz(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformBsh(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformDiv(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformJcc(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformLdm(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformMod(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformMul(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformNop(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformOr(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformStm(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformStr(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformSub(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformUndef(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformUnknown(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformUnknownOpcode(ReilInstruction var1, LatticeElementType var2);

    protected abstract Pair<LatticeElementType, LatticeElementType> transformXor(ReilInstruction var1, LatticeElementType var2);

    @Override
    public Pair<LatticeElementType, LatticeElementType> transform(IInstructionGraphNode n2, LatticeElementType state) {
        ReilInstruction ins = n2.getReilInstruction();
        Integer mnemonic = ins.getMnemonicCode();
        switch (mnemonic) {
            case 0: {
                return this.transformAdd(ins, state);
            }
            case 1: {
                return this.transformAnd(ins, state);
            }
            case 2: {
                return this.transformBisz(ins, state);
            }
            case 3: {
                return this.transformBsh(ins, state);
            }
            case 6: {
                return this.transformDiv(ins, state);
            }
            case 7: {
                return this.transformJcc(ins, state);
            }
            case 8: {
                return this.transformLdm(ins, state);
            }
            case 9: {
                return this.transformMod(ins, state);
            }
            case 10: {
                return this.transformMod(ins, state);
            }
            case 11: {
                return this.transformNop(ins, state);
            }
            case 12: {
                return this.transformOr(ins, state);
            }
            case 13: {
                return this.transformStm(ins, state);
            }
            case 14: {
                return this.transformStr(ins, state);
            }
            case 15: {
                return this.transformSub(ins, state);
            }
            case 16: {
                return this.transformUndef(ins, state);
            }
            case 17: {
                return this.transformUnknown(ins, state);
            }
            case 18: {
                return this.transformXor(ins, state);
            }
        }
        return this.transformUnknownOpcode(ins, state);
    }
}

