/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono2.common;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.algorithms.mono2.common.enums.AnalysisDirection;
import com.google.security.zynamics.reil.algorithms.mono2.common.instructiongraph.interfaces.IInstructionGraph;
import com.google.security.zynamics.reil.algorithms.mono2.common.instructiongraph.interfaces.IInstructionGraphEdge;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.ILattice;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.ILatticeElement;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.IMonoReilSolverResult;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MonoReilSolverResult<LatticeElementType extends ILatticeElement<LatticeElementType>>
implements IMonoReilSolverResult<LatticeElementType> {
    private final IInstructionGraph graph;
    private final AnalysisDirection direction;
    private final ILattice<LatticeElementType> lattice;
    private final Map<IInstructionGraphEdge, LatticeElementType> stateMap;
    private final Set<IInstructionGraphEdge> traversedEdges;

    public MonoReilSolverResult(IInstructionGraph graph, AnalysisDirection direction, ILattice<LatticeElementType> lattice, Map<IInstructionGraphEdge, LatticeElementType> stateMap, Set<IInstructionGraphEdge> traversedEdges) {
        this.graph = Preconditions.checkNotNull(graph, "Error: graph argument can not be null");
        this.lattice = Preconditions.checkNotNull(lattice, "Error: lattice argument can not be null");
        this.direction = Preconditions.checkNotNull(direction, "Error: direction argument can not be null");
        this.stateMap = Preconditions.checkNotNull(stateMap, "Error: stateMap argument can not be null");
        this.traversedEdges = Preconditions.checkNotNull(traversedEdges, "Error: traversedEdges argument can not be null");
    }

    private Iterator<Pair<IInstructionGraphEdge, LatticeElementType>> resultIterator() {
        return new ProxyIterator();
    }

    @Override
    public Map<IAddress, LatticeElementType> generateAddressToStateMapping(IInstruction startInstruction, boolean trackIncoming) {
        TreeMap<IAddress, LatticeElementType> addressToLatticeElementMap = new TreeMap<IAddress, LatticeElementType>();
        Iterator<Pair<IInstructionGraphEdge, LatticeElementType>> iter = this.resultIterator();
        while (iter.hasNext()) {
            IAddress address;
            Pair<IInstructionGraphEdge, LatticeElementType> edgeToLatticeElement = iter.next();
            if (!edgeToLatticeElement.first().isInstructionExit()) continue;
            if (this.hasResult(edgeToLatticeElement.first())) {
                address = this.direction == AnalysisDirection.DOWN ? this.graph.getSource(edgeToLatticeElement.first()).getReilInstruction().getAddress() : this.graph.getDestination(edgeToLatticeElement.first()).getReilInstruction().getAddress();
                if (addressToLatticeElementMap.containsKey(address)) {
                    ArrayList<Object> combinelist = new ArrayList<Object>();
                    combinelist.add(edgeToLatticeElement.second());
                    combinelist.add(addressToLatticeElementMap.get(address));
                    addressToLatticeElementMap.put(address, this.lattice.combine(combinelist));
                    continue;
                }
                addressToLatticeElementMap.put(address, edgeToLatticeElement.second());
                continue;
            }
            if (ReilHelpers.toNativeAddress(this.graph.getSource(edgeToLatticeElement.first()).getReilInstruction().getAddress()).equals(startInstruction.getAddress()) && this.direction == AnalysisDirection.DOWN && !trackIncoming) {
                address = this.graph.getSource(edgeToLatticeElement.first()).getReilInstruction().getAddress();
                addressToLatticeElementMap.put(address, edgeToLatticeElement.second());
                continue;
            }
            if (!ReilHelpers.toNativeAddress(this.graph.getDestination(edgeToLatticeElement.first()).getReilInstruction().getAddress()).equals(startInstruction.getAddress()) || this.direction != AnalysisDirection.UP || !trackIncoming) continue;
            address = this.graph.getDestination(edgeToLatticeElement.first()).getReilInstruction().getAddress();
            addressToLatticeElementMap.put(address, edgeToLatticeElement.second());
        }
        return addressToLatticeElementMap;
    }

    @Override
    public LatticeElementType getResult(IInstructionGraphEdge edge) {
        return (LatticeElementType)(this.hasResult(edge) ? (ILatticeElement)this.stateMap.get(edge) : null);
    }

    @Override
    public boolean hasResult(IInstructionGraphEdge instructionGraphEdge) {
        return this.traversedEdges.contains(instructionGraphEdge);
    }

    class ProxyIterator
    implements Iterator<Pair<IInstructionGraphEdge, LatticeElementType>> {
        private final Iterator<Map.Entry<IInstructionGraphEdge, LatticeElementType>> m_internalIterator;

        ProxyIterator() {
            this.m_internalIterator = MonoReilSolverResult.this.stateMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.m_internalIterator.hasNext();
        }

        @Override
        public Pair<IInstructionGraphEdge, LatticeElementType> next() {
            Map.Entry entry = this.m_internalIterator.next();
            return new Pair(entry.getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported operation on ProxyIterator: remove!");
        }
    }
}

