/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono2.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.security.zynamics.reil.algorithms.mono2.common.MonoReilSolverResult;
import com.google.security.zynamics.reil.algorithms.mono2.common.enums.AnalysisDirection;
import com.google.security.zynamics.reil.algorithms.mono2.common.instructiongraph.interfaces.IInstructionGraph;
import com.google.security.zynamics.reil.algorithms.mono2.common.instructiongraph.interfaces.IInstructionGraphEdge;
import com.google.security.zynamics.reil.algorithms.mono2.common.instructiongraph.interfaces.IInstructionGraphNode;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.ILattice;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.ILatticeElement;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.IMonoReilSolver;
import com.google.security.zynamics.reil.algorithms.mono2.common.interfaces.ITransformationProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MonoReilSolver<LatticeElementType extends ILatticeElement<LatticeElementType>>
implements IMonoReilSolver<LatticeElementType> {
    private final Map<IInstructionGraphEdge, LatticeElementType> m_stateMap = new HashMap<IInstructionGraphEdge, LatticeElementType>();
    private final MinMaxPriorityQueue<CComparableInstructionGraphNode> m_workList;
    private final AnalysisDirection m_direction;
    private final ILattice<LatticeElementType> m_lattice;
    private final IInstructionGraph m_graph;
    private final Set<IInstructionGraphEdge> m_traversedEdges = new HashSet<IInstructionGraphEdge>();

    public MonoReilSolver(IInstructionGraph instructionGraph, AnalysisDirection analysisDirection, ILattice<LatticeElementType> lattice) {
        this.m_graph = Preconditions.checkNotNull(instructionGraph, "Error: instruction graph argument can not be null");
        this.m_direction = Preconditions.checkNotNull(analysisDirection, "Error: analysis direction argument can not be null");
        this.m_lattice = Preconditions.checkNotNull(lattice, "Error: latice argument can not be null");
        this.m_workList = MinMaxPriorityQueue.expectedSize(this.m_graph.size()).create();
    }

    private Iterable<IInstructionGraphEdge> getRelevantEdges(CComparableInstructionGraphNode node) {
        if (this.m_direction == AnalysisDirection.DOWN) {
            return this.m_graph.getIncomingEdges(node.getNode());
        }
        return this.m_graph.getOutgoingEdges(node.getNode());
    }

    private void setOutgoingState(IInstructionGraphNode n2, Pair<LatticeElementType, LatticeElementType> states) {
        if (this.m_direction == AnalysisDirection.UP) {
            for (IInstructionGraphEdge instructionGraphEdge : this.m_graph.getIncomingEdges(n2)) {
                this.setStateInternal(instructionGraphEdge, (ILatticeElement)((ILatticeElement)states.first()).copy());
            }
        } else {
            for (IInstructionGraphEdge instructionGraphEdge : this.m_graph.getOutgoingEdges(n2)) {
                this.setStateInternal(instructionGraphEdge, instructionGraphEdge.isTrue() ? (ILatticeElement)((ILatticeElement)states.first()).copy() : (ILatticeElement)((ILatticeElement)states.second()).copy());
            }
        }
    }

    private void setState(IInstructionGraphEdge edge, LatticeElementType state) {
        if (edge.isInstructionExit()) {
            state.onInstructionExit();
        }
        if (this.m_stateMap.containsKey(edge)) {
            if (this.m_lattice.isSmallerEqual((ILatticeElement)state, (ILatticeElement)this.m_stateMap.get(edge))) {
                return;
            }
            ArrayList<LatticeElementType> combines = new ArrayList<LatticeElementType>();
            combines.add(state);
            combines.add(this.m_stateMap.get(edge));
            this.m_stateMap.put(edge, this.m_lattice.combine(combines));
        } else {
            this.m_stateMap.put(edge, state);
        }
        if (!this.m_lattice.isSmallerEqual(state, this.m_lattice.getMinimalElement())) {
            if (this.m_direction == AnalysisDirection.DOWN) {
                this.m_workList.add(new CComparableInstructionGraphNode(this.m_graph.getDestination(edge)));
            } else if (this.m_direction == AnalysisDirection.UP) {
                this.m_workList.add(new CComparableInstructionGraphNode(this.m_graph.getSource(edge)));
            }
        }
    }

    private void setStateInternal(IInstructionGraphEdge edge, LatticeElementType state) {
        this.m_traversedEdges.add(edge);
        this.setState(edge, state);
    }

    @Override
    public MonoReilSolverResult<LatticeElementType> solve(ITransformationProvider<LatticeElementType> transformationProvider, Iterable<Pair<IInstructionGraphEdge, LatticeElementType>> initialStates, int maximumIteration) {
        Preconditions.checkNotNull(transformationProvider, "Error: transformation provider argument can not be null");
        Preconditions.checkNotNull(initialStates, "Error: initialStates argument can not be null");
        for (Pair<IInstructionGraphEdge, LatticeElementType> initialState : initialStates) {
            this.setState(initialState.first(), (ILatticeElement)initialState.second());
        }
        while (this.m_workList.size() > 0) {
            if (--maximumIteration == 0) {
                throw new IllegalStateException("Solver could not generate a sane result");
            }
            CComparableInstructionGraphNode comparableInstructionGraphNode = this.m_workList.removeFirst();
            ArrayList<LatticeElementType> statesToCombine = new ArrayList<LatticeElementType>();
            for (IInstructionGraphEdge edge : this.getRelevantEdges(comparableInstructionGraphNode)) {
                if (!this.m_stateMap.containsKey(edge)) continue;
                statesToCombine.add(this.m_stateMap.get(edge));
            }
            LatticeElementType combinedState = this.m_lattice.combine(statesToCombine);
            Pair<LatticeElementType, LatticeElementType> newStates = transformationProvider.transform(comparableInstructionGraphNode.getNode(), combinedState);
            this.setOutgoingState(comparableInstructionGraphNode.getNode(), newStates);
        }
        return new MonoReilSolverResult<LatticeElementType>(this.m_graph, this.m_direction, this.m_lattice, this.m_stateMap, this.m_traversedEdges);
    }

    private class CComparableInstructionGraphNode
    implements Comparable<CComparableInstructionGraphNode> {
        private final IInstructionGraphNode m_node;
        private final int m_priority;

        CComparableInstructionGraphNode(IInstructionGraphNode n2) {
            this.m_node = n2;
            this.m_priority = 1;
        }

        private int getPriority() {
            return this.m_priority;
        }

        @Override
        public int compareTo(CComparableInstructionGraphNode o2) {
            return o2.getPriority() - this.m_priority;
        }

        public IInstructionGraphNode getNode() {
            return this.m_node;
        }
    }
}

