/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.BitwiseOr;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IElementGenerator;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.BaseTransformer;

public final class OrTransformer
extends BaseTransformer {
    private static IElementGenerator OR_GENERATOR = new OrGenerator();

    public static ValueTrackerElement transform(ReilInstruction instruction, ValueTrackerElement incomingState) {
        return OrTransformer.transform(instruction, incomingState, OR_GENERATOR);
    }

    private static class OrGenerator
    implements IElementGenerator {
        private OrGenerator() {
        }

        @Override
        public IValueElement generate(IValueElement lhs, IValueElement rhs) {
            if (lhs.equals(rhs)) {
                return lhs.clone();
            }
            return new BitwiseOr(lhs, rhs).getSimplified();
        }
    }
}

