/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.BitwiseAnd;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IElementGenerator;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Register;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Symbol;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.AndSimplifier;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.math.BigInteger;

public class BaseTransformer {
    private static IValueElement getOutputValue(ReilOperand firstOperand, IValueElement previousState1, ReilOperand secondOperand, IValueElement previousState2, IElementGenerator generator2) {
        if (previousState1 == null && previousState2 == null) {
            return generator2.generate(BaseTransformer.getAtomicType(firstOperand), BaseTransformer.getAtomicType(secondOperand));
        }
        if (previousState1 instanceof Undefined || previousState2 instanceof Undefined) {
            return new Undefined();
        }
        if (previousState1 != null && previousState2 == null) {
            return generator2.generate(previousState1, BaseTransformer.getAtomicType(secondOperand));
        }
        if (previousState1 == null && previousState2 != null) {
            return generator2.generate(BaseTransformer.getAtomicType(firstOperand), previousState2);
        }
        return generator2.generate(previousState1, previousState2);
    }

    private static boolean inputOperandsAreLiteralRegister(ReilInstruction instruction) {
        OperandType firstOperandType = instruction.getFirstOperand().getType();
        OperandType secondOperandType = instruction.getSecondOperand().getType();
        return firstOperandType == OperandType.INTEGER_LITERAL && secondOperandType == OperandType.REGISTER;
    }

    private static boolean inputOperandsAreLiterals(ReilInstruction instruction) {
        OperandType firstOperandType = instruction.getFirstOperand().getType();
        OperandType secondOperandType = instruction.getSecondOperand().getType();
        return firstOperandType == OperandType.INTEGER_LITERAL && secondOperandType == OperandType.INTEGER_LITERAL;
    }

    private static boolean inputOperandsAreRegisters(ReilInstruction instruction) {
        OperandType firstOperandType = instruction.getFirstOperand().getType();
        OperandType secondOperandType = instruction.getSecondOperand().getType();
        return firstOperandType == OperandType.REGISTER && secondOperandType == OperandType.REGISTER;
    }

    protected static IValueElement getAtomicType(ReilOperand operand) {
        return operand.getType() == OperandType.INTEGER_LITERAL ? new Literal(new BigInteger(operand.getValue())) : new Symbol(new CAddress(0L), operand.getValue());
    }

    protected static IValueElement getOperandValue(ReilOperand operand, ValueTrackerElement state) {
        return operand.getType() == OperandType.INTEGER_LITERAL ? new Literal(new BigInteger(operand.getValue())) : BaseTransformer.getState(state, operand);
    }

    protected static IValueElement getState(ValueTrackerElement state, ReilOperand inputOperand) {
        return state.getState(inputOperand.getValue());
    }

    protected static boolean inputOperandsAreRegisterLiteral(ReilInstruction instruction) {
        OperandType firstOperandType = instruction.getFirstOperand().getType();
        OperandType secondOperandType = instruction.getSecondOperand().getType();
        return firstOperandType == OperandType.REGISTER && secondOperandType == OperandType.INTEGER_LITERAL;
    }

    protected static ValueTrackerElement transform(ReilInstruction instruction, ValueTrackerElement incomingState, IElementGenerator generator2) {
        Preconditions.checkNotNull(instruction, "Error: instruction argument can not be null");
        Preconditions.checkNotNull(incomingState, "Error: incomingState argument can not be null");
        if (BaseTransformer.inputOperandsAreLiterals(instruction)) {
            return BaseTransformer.transformLiterals(instruction, incomingState, generator2);
        }
        if (BaseTransformer.inputOperandsAreRegisters(instruction)) {
            return BaseTransformer.transformRegisters(instruction, incomingState, generator2);
        }
        if (BaseTransformer.inputOperandsAreRegisterLiteral(instruction) || BaseTransformer.inputOperandsAreLiteralRegister(instruction)) {
            return BaseTransformer.transformRegisterLiteral(instruction, incomingState, generator2);
        }
        throw new IllegalStateException("Not yet implemented");
    }

    protected static ValueTrackerElement transformLiterals(ReilInstruction instruction, ValueTrackerElement incomingState, IElementGenerator generator2) {
        ReilOperand firstOperand = instruction.getFirstOperand();
        ReilOperand secondOperand = instruction.getSecondOperand();
        String thirdOperand = instruction.getThirdOperand().getValue();
        Register resultAloc = new Register(thirdOperand);
        IValueElement alocValue = generator2.generate(BaseTransformer.getAtomicType(firstOperand), BaseTransformer.getAtomicType(secondOperand));
        assert (alocValue instanceof Literal) : "The combination of two literals was not a literal";
        return incomingState.update(instruction, resultAloc, alocValue);
    }

    protected static ValueTrackerElement transformRegisterLiteral(ReilInstruction instruction, ValueTrackerElement incomingState, IElementGenerator generator2) {
        boolean registerFirst = BaseTransformer.inputOperandsAreRegisterLiteral(instruction);
        ReilOperand registerOperand = registerFirst ? instruction.getFirstOperand() : instruction.getSecondOperand();
        ReilOperand literalOperand = registerFirst ? instruction.getSecondOperand() : instruction.getFirstOperand();
        ReilOperand outputOperand = instruction.getThirdOperand();
        IValueElement previousState = incomingState.getState(registerOperand.getValue());
        IValueElement result = BaseTransformer.getOutputValue(registerOperand, previousState, literalOperand, null, generator2);
        if (previousState instanceof BitwiseAnd) {
            return AndSimplifier.simplifyAnd(instruction, registerOperand, literalOperand, (BitwiseAnd)previousState, incomingState, generator2);
        }
        return incomingState.update(instruction, new Register(outputOperand.getValue()), result);
    }

    protected static ValueTrackerElement transformRegisters(ReilInstruction instruction, ValueTrackerElement incomingState, IElementGenerator generator2) {
        ReilOperand firstOperand = instruction.getFirstOperand();
        ReilOperand secondOperand = instruction.getSecondOperand();
        ReilOperand thirdOperand = instruction.getThirdOperand();
        IValueElement previousState1 = incomingState.getState(firstOperand.getValue());
        IValueElement previousState2 = incomingState.getState(secondOperand.getValue());
        IValueElement outputValue = BaseTransformer.getOutputValue(firstOperand, previousState1, secondOperand, previousState2, generator2);
        return incomingState.update(instruction, new Register(thirdOperand.getValue()), outputValue);
    }
}

