/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.BitwiseAnd;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IElementGenerator;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.BaseTransformer;
import java.math.BigInteger;

public final class AndTransformer
extends BaseTransformer {
    private static IElementGenerator AND_GENERATOR = new AndGenerator();

    public static ValueTrackerElement transform(ReilInstruction instruction, ValueTrackerElement incomingState) {
        return AndTransformer.transform(instruction, incomingState, AND_GENERATOR);
    }

    private static class AndGenerator
    implements IElementGenerator {
        private AndGenerator() {
        }

        private static boolean eitherZero(IValueElement lhs, IValueElement rhs) {
            return lhs instanceof Literal && ((Literal)lhs).getValue().equals(BigInteger.ZERO) || rhs instanceof Literal && ((Literal)rhs).getValue().equals(BigInteger.ZERO);
        }

        @Override
        public IValueElement generate(IValueElement lhs, IValueElement rhs) {
            if (AndGenerator.eitherZero(lhs, rhs)) {
                return new Literal(BigInteger.ZERO);
            }
            if (lhs.equals(rhs)) {
                return lhs.clone();
            }
            return new BitwiseAnd(lhs, rhs).getSimplified();
        }
    }
}

