/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.BitwiseAnd;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IElementGenerator;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Register;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import java.math.BigInteger;

public class AndSimplifier {
    private static boolean isTruncateMask(IValueElement value, OperandSize size) {
        return value instanceof Literal && ((Literal)value).getValue().equals(BigInteger.valueOf(TranslationHelpers.getAllBitsMask(size)));
    }

    public static ValueTrackerElement simplifyAnd(ReilInstruction instruction, ReilOperand firstOperand, ReilOperand secondOperand, BitwiseAnd previousAnd, ValueTrackerElement state, IElementGenerator generator2) {
        ReilOperand thirdOperand = instruction.getThirdOperand();
        Register targetRegister = new Register(thirdOperand.getValue());
        if (AndSimplifier.isTruncateMask(previousAnd.getLhs(), firstOperand.getSize())) {
            IValueElement newAddition = generator2.generate(previousAnd.getRhs(), new Literal(new BigInteger(secondOperand.getValue())));
            BitwiseAnd newBitwiseAnd = new BitwiseAnd(new Literal(newAddition.evaluate()), previousAnd.getLhs());
            return state.update(instruction, targetRegister, newBitwiseAnd);
        }
        if (AndSimplifier.isTruncateMask(previousAnd.getRhs(), firstOperand.getSize())) {
            IValueElement previousLhs = previousAnd.getLhs();
            if (previousLhs instanceof Undefined) {
                return state.update(instruction, targetRegister, new Undefined());
            }
            IValueElement newAddition = generator2.generate(previousLhs, new Literal(new BigInteger(secondOperand.getValue())));
            BitwiseAnd newBitwiseAnd = new BitwiseAnd(newAddition.getSimplified(), previousAnd.getRhs());
            return state.update(instruction, targetRegister, newBitwiseAnd);
        }
        IValueElement previousState = state.getState(firstOperand.getValue());
        IValueElement addition = generator2.generate(previousState, new Literal(new BigInteger(secondOperand.getValue())));
        return state.update(instruction, targetRegister, addition);
    }
}

