/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import java.math.BigInteger;
import java.util.Set;

public class NullCheck
implements IValueElement {
    private final IValueElement m_value;

    public NullCheck(IValueElement element) {
        Preconditions.checkArgument(!(element instanceof Undefined), "Error: Element of a NullCheck can not be undefined");
        this.m_value = element.clone();
    }

    @Override
    public NullCheck clone() {
        return new NullCheck(this.m_value);
    }

    @Override
    public boolean equals(Object rhs) {
        return rhs instanceof NullCheck && ((NullCheck)rhs).m_value.equals(this.m_value);
    }

    @Override
    public BigInteger evaluate() {
        return this.m_value.evaluate().equals(BigInteger.ZERO) ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public IValueElement getSimplified() {
        if (this.m_value instanceof Literal) {
            return new Literal(this.m_value.evaluate().equals(BigInteger.ZERO) ? BigInteger.ONE : BigInteger.ZERO);
        }
        return this;
    }

    @Override
    public Set<String> getVariables() {
        return this.m_value.getVariables();
    }

    @Override
    public int hashCode() {
        return 5555 * this.m_value.hashCode();
    }

    public String toString() {
        String string2 = String.valueOf(this.m_value);
        return new StringBuilder(7 + String.valueOf(string2).length()).append("(").append(string2).append(" != 0)").toString();
    }
}

