/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements;

import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class Either
implements IValueElement {
    private final IValueElement m_lhs;
    private final IValueElement m_rhs;

    public Either(IValueElement lhs, IValueElement rhs) {
        this.m_lhs = lhs;
        this.m_rhs = rhs;
    }

    @Override
    public Either clone() {
        return new Either(this.m_lhs.clone(), this.m_rhs.clone());
    }

    @Override
    public boolean equals(Object rhs) {
        return rhs instanceof Either && ((Either)rhs).m_lhs.equals(this.m_lhs) && ((Either)rhs).m_rhs.equals(this.m_rhs);
    }

    @Override
    public BigInteger evaluate() {
        throw new IllegalStateException();
    }

    public IValueElement getLhs() {
        return this.m_lhs;
    }

    public IValueElement getRhs() {
        return this.m_rhs;
    }

    @Override
    public IValueElement getSimplified() {
        if (this.m_lhs.equals(this.m_rhs)) {
            return this.m_lhs.clone();
        }
        if (this.m_lhs instanceof Undefined || this.m_rhs instanceof Undefined) {
            return new Undefined();
        }
        return this;
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> variables = new HashSet<String>();
        variables.addAll(this.m_lhs.getVariables());
        variables.addAll(this.m_rhs.getVariables());
        return variables;
    }

    @Override
    public int hashCode() {
        return 555 * this.m_lhs.hashCode() * this.m_rhs.hashCode();
    }

    public String toString() {
        String string2 = String.valueOf(this.m_lhs);
        String string3 = String.valueOf(this.m_rhs);
        return new StringBuilder(6 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(").append(string2).append(" || ").append(string3).append(")").toString();
    }
}

