/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking;

import com.google.common.collect.Sets;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILatticeElementMono1;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IAloc;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.MemoryCell;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Register;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ValueTrackerElement
implements ILatticeElementMono1<ValueTrackerElement>,
Cloneable {
    private final Map<IAloc, IValueElement> m_values;
    private final Set<ReilInstruction> m_influences;
    private final Map<String, Set<IAddress>> m_lastWritten;

    public ValueTrackerElement() {
        this(new LinkedHashSet<ReilInstruction>(), new HashMap<IAloc, IValueElement>(), new HashMap<String, Set<IAddress>>());
    }

    public ValueTrackerElement(Set<ReilInstruction> influences, Map<IAloc, IValueElement> values, Map<String, Set<IAddress>> lastWritten) {
        this.m_values = new HashMap<IAloc, IValueElement>(values);
        this.m_influences = new LinkedHashSet<ReilInstruction>(influences);
        this.m_lastWritten = new HashMap<String, Set<IAddress>>(lastWritten);
    }

    private static Map<String, Set<IAddress>> createLastWritten(Map<String, Set<IAddress>> written, ReilInstruction influence) {
        HashMap<String, Set<IAddress>> newWritten = new HashMap<String, Set<IAddress>>(written);
        newWritten.remove(influence.getAddress());
        newWritten.put(influence.getThirdOperand().getValue(), Sets.newHashSet(influence.getAddress()));
        return newWritten;
    }

    public ValueTrackerElement clone() {
        return new ValueTrackerElement(this.m_influences, this.m_values, this.m_lastWritten);
    }

    @Override
    public boolean equals(ValueTrackerElement rhs) {
        return this.m_values.equals(rhs.m_values) && this.m_lastWritten.equals(rhs.m_lastWritten);
    }

    public Set<ReilInstruction> getInfluences() {
        return new HashSet<ReilInstruction>(this.m_influences);
    }

    public Map<String, Set<IAddress>> getLastWritten() {
        return new HashMap<String, Set<IAddress>>(this.m_lastWritten);
    }

    public IValueElement getState(IAloc aloc) {
        return this.m_values.get(aloc);
    }

    public IValueElement getState(String register2) {
        return this.getState(new Register(register2));
    }

    public Map<IAloc, IValueElement> getStates() {
        return new HashMap<IAloc, IValueElement>(this.m_values);
    }

    @Override
    public boolean lessThan(ValueTrackerElement rhs) {
        throw new IllegalStateException("Not yet implemented");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Map.Entry<IAloc, IValueElement>> entries = new ArrayList<Map.Entry<IAloc, IValueElement>>(this.m_values.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<IAloc, IValueElement>>(){

            @Override
            public int compare(Map.Entry<IAloc, IValueElement> o1, Map.Entry<IAloc, IValueElement> o2) {
                IAloc lhs = o1.getKey();
                IAloc rhs = o2.getKey();
                if (lhs instanceof Register && rhs instanceof Register && ReilHelpers.isTemporaryRegister(((Register)lhs).getName()) && ReilHelpers.isTemporaryRegister(((Register)rhs).getName())) {
                    return ((Register)lhs).getName().compareToIgnoreCase(((Register)rhs).getName());
                }
                if (lhs instanceof Register && rhs instanceof Register && ReilHelpers.isTemporaryRegister(((Register)lhs).getName()) && !ReilHelpers.isTemporaryRegister(((Register)rhs).getName())) {
                    return 1;
                }
                if (lhs instanceof Register && rhs instanceof Register && !ReilHelpers.isTemporaryRegister(((Register)lhs).getName()) && ReilHelpers.isTemporaryRegister(((Register)rhs).getName())) {
                    return -1;
                }
                if (lhs instanceof Register && rhs instanceof Register && !ReilHelpers.isTemporaryRegister(((Register)lhs).getName()) && !ReilHelpers.isTemporaryRegister(((Register)rhs).getName())) {
                    return ((Register)lhs).getName().compareTo(((Register)rhs).getName());
                }
                if (lhs instanceof MemoryCell && rhs instanceof MemoryCell) {
                    return ((MemoryCell)lhs).toString().compareTo(((MemoryCell)rhs).toString());
                }
                if (lhs instanceof MemoryCell && rhs instanceof Register) {
                    return 1;
                }
                if (lhs instanceof Register && rhs instanceof MemoryCell) {
                    return -1;
                }
                System.out.println(lhs);
                System.out.println(rhs);
                throw new IllegalStateException();
            }
        });
        for (Map.Entry entry : entries) {
            sb.append("[");
            sb.append(entry.getKey());
            sb.append(" -> ");
            sb.append(entry.getValue());
            sb.append("]");
        }
        return sb.toString();
    }

    public ValueTrackerElement update(ReilInstruction influence, IAloc aloc, IValueElement value) {
        if (this.m_influences.contains(influence) && this.getState(aloc) != null && !influence.getThirdOperand().getValue().equals(aloc.toString()) && !value.equals(this.getState(aloc))) {
            System.out.println(influence);
            String string2 = String.valueOf(aloc);
            String string3 = String.valueOf(value);
            System.out.println(new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" -> ").append(string3).toString());
            System.out.println(this.getState(aloc));
            System.out.println(this.m_influences);
            System.out.println(this.m_values);
            throw new IllegalStateException();
        }
        HashSet<ReilInstruction> newInfluences = new HashSet<ReilInstruction>(this.m_influences);
        newInfluences.add(influence);
        Map<String, Set<IAddress>> newLastWritten = ValueTrackerElement.createLastWritten(this.m_lastWritten, influence);
        HashMap<IAloc, IValueElement> updatedValues = new HashMap<IAloc, IValueElement>(this.m_values);
        updatedValues.put(aloc, value);
        return new ValueTrackerElement(newInfluences, updatedValues, newLastWritten);
    }
}

