/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.algorithms.mono.InfluencingInstructionNode;
import com.google.security.zynamics.reil.algorithms.mono.InstructionGraphEdge;
import com.google.security.zynamics.reil.algorithms.mono.InstructionGraphNode;
import com.google.security.zynamics.reil.algorithms.mono.WalkInformation;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.IGraphWalker;
import com.google.security.zynamics.zylib.types.graphs.DefaultEdge;
import java.util.List;
import java.util.stream.Collectors;

public final class DownWalker
implements IGraphWalker<InstructionGraphNode, WalkInformation> {
    @Override
    public List<InstructionGraphNode> getInfluenced(InstructionGraphNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        return node.getOutgoingEdges().stream().map(DefaultEdge::getTarget).collect(Collectors.toList());
    }

    @Override
    public List<InfluencingInstructionNode> getInfluencing(InstructionGraphNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        return node.getIncomingEdges().stream().map(edge -> new InfluencingInstructionNode((InstructionGraphNode)edge.getSource(), new WalkInformation((InstructionGraphEdge)edge))).collect(Collectors.toList());
    }
}

