/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ReilInstruction
implements IInstruction,
Comparable<ReilInstruction> {
    private IAddress address;
    private final Integer mnemonic;
    private final ReilOperand firstOperand;
    private final ReilOperand secondOperand;
    private final ReilOperand thirdOperand;
    private final Map<String, String> metaData = new HashMap<String, String>();

    public ReilInstruction(IAddress address, String mnemonic, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        Preconditions.checkNotNull(mnemonic, "Argument mnemonic can't be null");
        this.mnemonic = ReilHelpers.MnemonicToMnemonicCode(mnemonic);
        this.firstOperand = Preconditions.checkNotNull(firstOperand);
        this.secondOperand = Preconditions.checkNotNull(secondOperand);
        this.thirdOperand = Preconditions.checkNotNull(thirdOperand);
        this.address = address;
    }

    private String getMetaDataString() {
        return this.metaData.keySet().stream().map(key -> {
            String string2 = this.metaData.get(key);
            return new StringBuilder(3 + String.valueOf(key).length() + String.valueOf(string2).length()).append((String)key).append(" : ").append(string2).toString();
        }).collect(Collectors.joining(", "));
    }

    @Override
    public int compareTo(ReilInstruction o2) {
        return this.address.compareTo(o2.address);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof ReilInstruction)) {
            return false;
        }
        ReilInstruction rhsInstruction = (ReilInstruction)rhs;
        return this.address.equals(rhsInstruction.getAddress()) && rhsInstruction.getMnemonic().equals(this.mnemonic) && this.firstOperand.equals(rhsInstruction.getFirstOperand()) && this.secondOperand.equals(rhsInstruction.getSecondOperand()) && this.thirdOperand.equals(rhsInstruction.getThirdOperand()) && this.metaData.equals(rhsInstruction.getMetaData());
    }

    @Override
    public IAddress getAddress() {
        return this.address;
    }

    @Override
    public String getArchitecture() {
        return "REIL";
    }

    @Override
    public byte[] getData() {
        return new byte[0];
    }

    public ReilOperand getFirstOperand() {
        return this.firstOperand;
    }

    @Override
    public long getLength() {
        return 1L;
    }

    public Map<String, String> getMetaData() {
        return new HashMap<String, String>(this.metaData);
    }

    public String getMetaData(String key) {
        Preconditions.checkNotNull(key, "Argument key can't be null");
        return this.metaData.get(key);
    }

    @Override
    public String getMnemonic() {
        return ReilHelpers.MnemonicCodeToMnemonic(this.mnemonic);
    }

    @Override
    public Integer getMnemonicCode() {
        return this.mnemonic;
    }

    public List<IOperandTree> getOperands() {
        ArrayList<IOperandTree> operands = new ArrayList<IOperandTree>();
        operands.add(this.firstOperand);
        operands.add(this.secondOperand);
        operands.add(this.thirdOperand);
        return operands;
    }

    public ReilOperand getSecondOperand() {
        return this.secondOperand;
    }

    public ReilOperand getThirdOperand() {
        return this.thirdOperand;
    }

    public String getTupleString() {
        return String.format("%010X: (%s, (%s, %s, %s), (%s, %s, %s), [%s])", new Object[]{this.address, this.mnemonic, this.firstOperand.getValue(), this.secondOperand.getValue(), this.thirdOperand.getValue(), this.firstOperand.getSize(), this.secondOperand.getSize(), this.thirdOperand.getSize(), this.getMetaDataString()});
    }

    public int hashCode() {
        return this.address.hashCode() * (this.mnemonic + 1) * this.firstOperand.hashCode() * this.secondOperand.hashCode() * this.thirdOperand.hashCode() * this.metaData.hashCode();
    }

    public void setMetaData(String key, String value) {
        Preconditions.checkNotNull(key, "Argument key can't be null");
        if (value == null) {
            this.metaData.remove(key);
        } else {
            this.metaData.put(key, value);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.address.toHexString());
        stringBuilder.append(": ");
        stringBuilder.append(ReilHelpers.MnemonicCodeToMnemonic(this.mnemonic));
        stringBuilder.append(" [");
        stringBuilder.append((Object)this.firstOperand.getSize());
        stringBuilder.append(" ");
        stringBuilder.append(this.firstOperand);
        stringBuilder.append(", ");
        stringBuilder.append((Object)this.secondOperand.getSize());
        stringBuilder.append(" ");
        stringBuilder.append(this.secondOperand);
        stringBuilder.append(", ");
        stringBuilder.append((Object)this.thirdOperand.getSize());
        stringBuilder.append(" ");
        stringBuilder.append(this.thirdOperand);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void setAddress(IAddress newAddress) {
        this.address = newAddress;
    }
}

