/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.ReilOperandNode;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Convert;
import java.util.ArrayList;
import java.util.List;

public class ReilHelpers {
    public static final String OPCODE_ADD = "add";
    public static final int _OPCODE_ADD = 0;
    public static final String OPCODE_AND = "and";
    public static final int _OPCODE_AND = 1;
    public static final String OPCODE_BISZ = "bisz";
    public static final int _OPCODE_BISZ = 2;
    public static final String OPCODE_BSH = "bsh";
    public static final int _OPCODE_BSH = 3;
    public static final String OPCODE_CONSUME = "consume";
    public static final int _OPCODE_CONSUME = 4;
    public static final String OPCODE_DEFINE = "define";
    public static final int _OPCODE_DEFINE = 5;
    public static final String OPCODE_DIV = "div";
    public static final int _OPCODE_DIV = 6;
    public static final String OPCODE_JCC = "jcc";
    public static final int _OPCODE_JCC = 7;
    public static final String OPCODE_LDM = "ldm";
    public static final int _OPCODE_LDM = 8;
    public static final String OPCODE_MOD = "mod";
    public static final int _OPCODE_MOD = 9;
    public static final String OPCODE_MUL = "mul";
    public static final int _OPCODE_MUL = 10;
    public static final String OPCODE_NOP = "nop";
    public static final int _OPCODE_NOP = 11;
    public static final String OPCODE_OR = "or";
    public static final int _OPCODE_OR = 12;
    public static final String OPCODE_STM = "stm";
    public static final int _OPCODE_STM = 13;
    public static final String OPCODE_STR = "str";
    public static final int _OPCODE_STR = 14;
    public static final String OPCODE_SUB = "sub";
    public static final int _OPCODE_SUB = 15;
    public static final String OPCODE_UNDEF = "undef";
    public static final int _OPCODE_UNDEF = 16;
    public static final String OPCODE_UNKNOWN = "unkn";
    public static final int _OPCODE_UNKNOWN = 17;
    public static final String OPCODE_XOR = "xor";
    public static final int _OPCODE_XOR = 18;
    private static final ImmutableBiMap<String, Integer> MnemonicCodeMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().put("add", (Object)0)).put("and", (Object)1)).put("bisz", (Object)2)).put("bsh", (Object)3)).put("consume", (Object)4)).put("define", (Object)5)).put("div", (Object)6)).put("jcc", (Object)7)).put("ldm", (Object)8)).put("mod", (Object)9)).put("mul", (Object)10)).put("nop", (Object)11)).put("or", (Object)12)).put("stm", (Object)13)).put("str", (Object)14)).put("sub", (Object)15)).put("undef", (Object)16)).put("unkn", (Object)17)).put("xor", (Object)18)).build();

    private static ReilInstruction createBinaryInstruction(String opcode2, IAddress offset, OperandSize firstSize, String firstValue, OperandSize thirdSize, String thirdValue, String ... meta) {
        Preconditions.checkArgument(meta.length % 2 == 0, "Invalid number of arguments in metadata array.");
        ReilOperand firstOperand = ReilHelpers.createOperand(firstSize, firstValue);
        ReilOperand secondOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        ReilOperand thirdOperand = ReilHelpers.createOperand(thirdSize, thirdValue);
        ReilInstruction instruction = new ReilInstruction(offset, opcode2, firstOperand, secondOperand, thirdOperand);
        for (int i2 = 0; i2 < meta.length; i2 += 2) {
            instruction.setMetaData(meta[i2], meta[i2 + 1]);
        }
        return instruction;
    }

    private static ReilInstruction createTrinaryInstruction(String opcode2, IAddress offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        ReilOperand firstOperand = ReilHelpers.createOperand(firstSize, firstValue);
        ReilOperand secondOperand = ReilHelpers.createOperand(secondSize, secondValue);
        ReilOperand thirdOperand = ReilHelpers.createOperand(thirdSize, thirdValue);
        ReilHelpers.checkTrinaryOperandSizeTypes(firstSize, secondSize, thirdSize);
        return new ReilInstruction(offset, opcode2, firstOperand, secondOperand, thirdOperand);
    }

    private static void checkTrinaryOperandSizeTypes(OperandSize first, OperandSize second, OperandSize third) {
        ReilHelpers.checkBinaryOperandSizeTypes(first, second);
        Preconditions.checkNotNull(third, "First size argument can not be null.");
        Preconditions.checkArgument(third != OperandSize.ADDRESS, "The size for the third argument can not be of type ADDRESS.");
    }

    private static void checkBinaryOperandSizeTypes(OperandSize first, OperandSize second) {
        Preconditions.checkNotNull(first, "First size argument can not be null.");
        Preconditions.checkNotNull(second, "Second size argument can not be null.");
        Preconditions.checkArgument(first != OperandSize.ADDRESS, "The size for the first argument can not be of type ADDRESS.");
        Preconditions.checkArgument(second != OperandSize.ADDRESS, "The size for the second argument can not be of type ADDRESS.");
    }

    public static ReilInstruction createAdd(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_ADD, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createAnd(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_AND, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createBisz(long offset, OperandSize firstSize, String firstValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createBinaryInstruction(OPCODE_BISZ, new CAddress(offset), firstSize, firstValue, thirdSize, thirdValue, new String[0]);
    }

    public static ReilInstruction createBsh(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_BSH, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createDefine(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_DEFINE, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createDiv(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_DIV, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createJcc(long offset, OperandSize firstSize, String firstValue, OperandSize thirdSize, String thirdValue, String ... meta) {
        return ReilHelpers.createBinaryInstruction(OPCODE_JCC, new CAddress(offset), firstSize, firstValue, thirdSize, thirdValue, meta);
    }

    public static ReilInstruction createLdm(long offset, OperandSize firstSize, String firstValue, OperandSize thirdSize, String thirdValue) {
        ReilHelpers.checkBinaryOperandSizeTypes(firstSize, thirdSize);
        return ReilHelpers.createBinaryInstruction(OPCODE_LDM, new CAddress(offset), firstSize, firstValue, thirdSize, thirdValue, new String[0]);
    }

    public static ReilInstruction createMod(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_MOD, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createMul(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_MUL, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createNop(long offset) {
        ReilOperand firstOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        ReilOperand secondOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        ReilOperand thirdOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        return new ReilInstruction(new CAddress(offset), OPCODE_NOP, firstOperand, secondOperand, thirdOperand);
    }

    public static ReilOperand createOperand(OperandSize size, String value) {
        ReilOperandNode root = new ReilOperandNode(size.toSizeString(), ExpressionType.SIZE_PREFIX);
        ReilOperandNode child = new ReilOperandNode(value, ReilHelpers.getOperandType(value));
        ReilOperandNode.link(root, child);
        return new ReilOperand(root);
    }

    public static ReilInstruction createOr(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_OR, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createStm(long offset, OperandSize firstSize, String firstValue, OperandSize thirdSize, String thirdValue) {
        ReilHelpers.checkBinaryOperandSizeTypes(firstSize, thirdSize);
        return ReilHelpers.createBinaryInstruction(OPCODE_STM, new CAddress(offset), firstSize, firstValue, thirdSize, thirdValue, new String[0]);
    }

    public static ReilInstruction createStr(long offset, OperandSize firstSize, String firstValue, OperandSize thirdSize, String thirdValue) {
        ReilHelpers.checkBinaryOperandSizeTypes(firstSize, thirdSize);
        return ReilHelpers.createBinaryInstruction(OPCODE_STR, new CAddress(offset), firstSize, firstValue, thirdSize, thirdValue, new String[0]);
    }

    public static ReilInstruction createSub(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_SUB, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ReilInstruction createUndef(long offset, OperandSize size, String value) {
        ReilOperand firstOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        ReilOperand secondOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        ReilOperand thirdOperand = ReilHelpers.createOperand(size, value);
        return new ReilInstruction(new CAddress(offset), OPCODE_UNDEF, firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createUnknown(long offset) {
        ReilOperand firstOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        ReilOperand secondOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        ReilOperand thirdOperand = ReilHelpers.createOperand(OperandSize.EMPTY, "");
        return new ReilInstruction(new CAddress(offset), OPCODE_UNKNOWN, firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createXor(long offset, OperandSize firstSize, String firstValue, OperandSize secondSize, String secondValue, OperandSize thirdSize, String thirdValue) {
        return ReilHelpers.createTrinaryInstruction(OPCODE_XOR, new CAddress(offset), firstSize, firstValue, secondSize, secondValue, thirdSize, thirdValue);
    }

    public static ExpressionType getOperandType(String value) {
        if (Convert.isDecString(value) || value.startsWith("-")) {
            return ExpressionType.IMMEDIATE_INTEGER;
        }
        if (value.startsWith("t")) {
            return ExpressionType.SYMBOL;
        }
        if (OperandSize.isSizeString(value)) {
            return ExpressionType.SIZE_PREFIX;
        }
        return ExpressionType.REGISTER;
    }

    public static boolean isBinaryInstruction(String mnemonic) {
        return mnemonic.equals(OPCODE_ADD) || mnemonic.equals(OPCODE_SUB) || mnemonic.equals(OPCODE_MUL) || mnemonic.equals(OPCODE_DIV) || mnemonic.equals(OPCODE_BSH) || mnemonic.equals(OPCODE_AND) || mnemonic.equals(OPCODE_OR) || mnemonic.equals(OPCODE_XOR);
    }

    public static boolean isConditionalJump(ReilInstruction instruction) {
        Preconditions.checkNotNull(instruction, "Argument instruction can't be null.");
        return instruction.getMnemonic().equals(OPCODE_JCC) && instruction.getFirstOperand().getType() == OperandType.REGISTER;
    }

    public static boolean isDelayedBranch(ReilInstruction instruction) {
        return instruction.getMetaData().containsKey("branch_delay") && instruction.getMetaData().get("branch_delay").equalsIgnoreCase("true");
    }

    public static boolean isDelayedTrueBranch(ReilInstruction instruction) {
        return instruction.getMetaData().containsKey("branch_delay_true") && instruction.getMetaData().get("branch_delay_true").equalsIgnoreCase("true");
    }

    public static boolean isFunctionCall(ReilInstruction instruction) {
        return instruction.getMetaData().containsKey("isCall") && instruction.getMetaData().get("isCall").equalsIgnoreCase("true");
    }

    public static boolean isJump(ReilInstruction instruction) {
        Preconditions.checkNotNull(instruction, "Argument instruction can't be null.");
        return instruction.getMnemonic().equals(OPCODE_JCC);
    }

    public static boolean isNativeRegister(ReilOperand operand) {
        return operand.getType() == OperandType.REGISTER && !ReilHelpers.isTemporaryRegister(operand);
    }

    public static boolean isTemporaryRegister(ReilOperand operand) {
        return operand.getType() == OperandType.REGISTER && operand.getValue().startsWith("t");
    }

    public static boolean isTemporaryRegister(String value) {
        return value.startsWith("t");
    }

    public static boolean isUnaryInstruction(String mnemonic) {
        return mnemonic.equals(OPCODE_BISZ) || mnemonic.equals(OPCODE_STR);
    }

    public static boolean isUnconditionalJump(ReilInstruction instruction) {
        Preconditions.checkNotNull(instruction, "Argument instruction can't be null.");
        return instruction.getMnemonic().equals(OPCODE_JCC) && !ReilHelpers.isConditionalJump(instruction);
    }

    public static boolean isValidReilMnemonic(String mnemonic) {
        return MnemonicCodeMap.containsKey(mnemonic);
    }

    public static String MnemonicCodeToMnemonic(int code2) {
        return (String)((ImmutableMap)((Object)MnemonicCodeMap.inverse())).get(code2);
    }

    public static int MnemonicToMnemonicCode(String mnemonic) {
        Preconditions.checkNotNull(mnemonic, "Mnemonic argument can not be null.");
        return (Integer)MnemonicCodeMap.get(mnemonic);
    }

    public static boolean setsValue(ReilInstruction instruction, String register2) {
        return instruction.getThirdOperand().getValue().equals(register2);
    }

    public static long subAddressToLong(String subaddress) {
        Preconditions.checkNotNull(subaddress, "Argument subaddress can't be null.");
        if (subaddress.contains(".")) {
            String[] parts = subaddress.split("\\.");
            Preconditions.checkArgument(parts.length == 2, "Argument subaddress is not a valid subaddress.");
            long firstPart = Long.parseLong(parts[0]);
            long secondPart = Long.parseLong(parts[1]);
            return firstPart * 256L + secondPart;
        }
        throw new IllegalArgumentException("Argument subaddress is not a valid subaddress.");
    }

    public static IAddress toNativeAddress(IAddress address) {
        return new CAddress(address.toLong() / 256L);
    }

    public static IAddress toReilAddress(IAddress address) {
        return new CAddress(address.toLong() * 256L);
    }

    public static boolean uses(ReilInstruction instruction, String register2) {
        return instruction.getFirstOperand().getValue().equals(register2) || instruction.getSecondOperand().getValue().equals(register2) || instruction.getMnemonic().equals(OPCODE_STM) && instruction.getThirdOperand().getValue().equals(register2) || instruction.getMnemonic().equals(OPCODE_JCC) && instruction.getThirdOperand().getValue().equals(register2);
    }

    public static boolean usesFirstOperand(Integer mnemonic) {
        return !mnemonic.equals(11);
    }

    public static boolean usesSecondOperand(Integer mnemonic) {
        return !mnemonic.equals(11) && !mnemonic.equals(2) && !mnemonic.equals(14) && !mnemonic.equals(13) && !mnemonic.equals(8) && !mnemonic.equals(7);
    }

    public static boolean usesThirdOperand(String mnemonic) {
        return !mnemonic.equals(OPCODE_NOP);
    }

    public static List<String> useValues(ReilInstruction instruction) {
        ArrayList<String> values = new ArrayList<String>();
        if (instruction.getFirstOperand().getType() == OperandType.REGISTER) {
            values.add(instruction.getFirstOperand().getValue());
        }
        if (instruction.getSecondOperand().getType() == OperandType.REGISTER) {
            values.add(instruction.getSecondOperand().getValue());
        }
        return values;
    }

    public static boolean writesThirdOperand(Integer mnemonic) {
        return !mnemonic.equals(13) && !mnemonic.equals(7) && !mnemonic.equals(11);
    }

    public static long nextReilAddress(IInstruction instruction, List<ReilInstruction> instructions) {
        return instruction.getAddress().toLong() * 256L + (long)instructions.size();
    }
}

