/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil;

import com.google.common.collect.Iterables;
import com.google.security.zynamics.reil.ReilEdge;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.ICodeContainer;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ReilBlock
implements ICodeContainer<ReilInstruction>,
Iterable<ReilInstruction>,
IGraphNode<ReilBlock> {
    private final List<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
    private final List<ReilEdge> outedges = new ArrayList<ReilEdge>();
    private final List<ReilEdge> inedges = new ArrayList<ReilEdge>();

    public ReilBlock(Collection<ReilInstruction> instructions) {
        this.instructions.addAll(instructions);
    }

    public static void link(ReilBlock source, ReilBlock target, ReilEdge edge) {
        source.outedges.add(edge);
        target.inedges.add(edge);
    }

    public static void unlink(ReilBlock source, ReilBlock target, ReilEdge edge) {
        source.outedges.remove(edge);
        target.inedges.remove(edge);
    }

    public void addInstruction(ReilInstruction instruction) {
        this.instructions.add(instruction);
    }

    @Override
    public IAddress getAddress() {
        return this.instructions.get(0).getAddress();
    }

    @Override
    public List<? extends ReilBlock> getChildren() {
        ArrayList<ReilBlock> children = new ArrayList<ReilBlock>();
        for (ReilEdge edge : this.getOutgoingEdges()) {
            children.add(edge.getTarget());
        }
        return children;
    }

    public List<ReilEdge> getIncomingEdges() {
        return new ArrayList<ReilEdge>(this.inedges);
    }

    @Override
    public Iterable<ReilInstruction> getInstructions() {
        return this.instructions;
    }

    @Override
    public ReilInstruction getLastInstruction() {
        return Iterables.getLast(this.instructions);
    }

    @Override
    public List<ReilEdge> getOutgoingEdges() {
        return new ArrayList<ReilEdge>(this.outedges);
    }

    @Override
    public List<? extends ReilBlock> getParents() {
        ArrayList<ReilBlock> parents = new ArrayList<ReilBlock>();
        for (ReilEdge edge : this.getIncomingEdges()) {
            parents.add(edge.getTarget());
        }
        return parents;
    }

    @Override
    public boolean hasInstruction(ReilInstruction instruction) {
        return this.instructions.contains(instruction);
    }

    @Override
    public Iterator<ReilInstruction> iterator() {
        return this.instructions.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("REIL Block ");
        builder.append(this.getAddress().toHexString());
        builder.append("\n");
        for (ReilInstruction instruction : this.getInstructions()) {
            builder.append(instruction.toString());
            builder.append("\n");
        }
        return builder.toString();
    }
}

