/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph;

import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyNodeContentHelpers;
import java.awt.Color;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import javax.swing.TransferHandler;
import y.i.aM;
import y.i.aO;
import y.i.ar;

public class ZyGraphDragAndDropSupport {
    private final ZyGraph graph;
    private final TransferHandler transferHandler;
    private NaviNode lastNode;
    private int lastRow;
    private static final int HIGHLIGHTING_LEVEL = 0;
    private static final Color HIGHLIGHTING_COLOR = Color.ORANGE;

    public ZyGraphDragAndDropSupport(ZyGraph zyGraph, TransferHandler transferHandler) {
        this.graph = zyGraph;
        this.transferHandler = transferHandler;
    }

    public static DragOverState getDragOverState(ZyGraph zyGraph, Point point) {
        NaviNode naviNode;
        ar ar2 = zyGraph.getView();
        double d2 = ar2.toWorldCoordX((int)point.getX());
        double d3 = ar2.toWorldCoordY((int)point.getY());
        aO aO2 = ar2.getHitInfoFactory();
        aM aM2 = aO2.a(d2, d3, 1, true);
        if (aM2.t() && (naviNode = (NaviNode)zyGraph.getMappings().getNode(aM2.i())) != null) {
            return new DragOverState(naviNode, ZyNodeContentHelpers.getObjectWrapper(naviNode, d2, d3));
        }
        return new DragOverState(null, null);
    }

    private void clearHighlighting(NaviNode naviNode) {
        if (this.lastNode != null) {
            this.lastNode.clearHighlighting(0, this.lastRow);
        }
        this.lastNode = naviNode;
    }

    private void handleDragOver(Point point) {
        DragOverState dragOverState = ZyGraphDragAndDropSupport.getDragOverState(this.graph, point);
        NaviNode naviNode = dragOverState.getNode();
        if (naviNode != null && dragOverState.getDragOverObject() != null) {
            int n2;
            Object object = dragOverState.getDragOverObject().getObject();
            if (object instanceof INaviOperandTreeNode && ((INaviOperandTreeNode)object).getType() == ExpressionType.REGISTER && (n2 = naviNode.positionToRow(this.graph.getView().toWorldCoordY(point.y) - naviNode.getY())) != -1) {
                this.clearHighlighting(naviNode);
                this.lastRow = n2;
                ZyLineContent.ObjectWrapper objectWrapper = dragOverState.getDragOverObject();
                naviNode.setHighlighting(0, n2, objectWrapper.getStart(), objectWrapper.getLength(), HIGHLIGHTING_COLOR);
            }
        } else {
            this.clearHighlighting(null);
        }
    }

    public void enableDndSupport() {
        this.graph.getView().setTransferHandler(this.transferHandler);
        try {
            this.graph.getView().getDropTarget().addDropTargetListener(new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                }

                @Override
                public void dragExit(DropTargetEvent dropTargetEvent) {
                    ZyGraphDragAndDropSupport.this.clearHighlighting(null);
                }

                @Override
                public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                    ZyGraphDragAndDropSupport.this.handleDragOver(dropTargetDragEvent.getLocation());
                }

                @Override
                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    ZyGraphDragAndDropSupport.this.clearHighlighting(null);
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                }
            });
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
        }
    }

    public static class DragOverState {
        private final NaviNode node;
        private final ZyLineContent.ObjectWrapper dragOverObject;

        public DragOverState(NaviNode naviNode, ZyLineContent.ObjectWrapper objectWrapper) {
            this.node = naviNode;
            this.dragOverObject = objectWrapper;
        }

        public ZyLineContent.ObjectWrapper getDragOverObject() {
            return this.dragOverObject;
        }

        public NaviNode getNode() {
            return this.node;
        }
    }
}

