/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph.Synchronizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.ITagListener;
import com.google.security.zynamics.binnavi.ZyGraph.INaviGraphListener;
import com.google.security.zynamics.binnavi.ZyGraph.IZyGraphInternals;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.CEdgeDrawingFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.Synchronizers.CEdgeDrawingSynchronizer;
import com.google.security.zynamics.binnavi.ZyGraph.Synchronizers.CGraphSettingsSynchronizer;
import com.google.security.zynamics.binnavi.disassembly.CNaviGroupNodeListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.ZyEdgeBuilder;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.ZyGraphNodeBuilder;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.MultiEdgeHider;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraphMappings;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeRealizer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyNodeRealizer;
import com.google.security.zynamics.zylib.yfileswrap.yfiles.YHelpers;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import y.c.d;
import y.c.p;

public final class CViewGraphSynchronizer {
    private final ZyGraph m_graph;
    private final IZyGraphInternals m_graphInternals;
    private final ZyGraphMappings<NaviNode, NaviEdge> m_mappings;
    private final InternalViewListener m_viewListener = new InternalViewListener();
    private final InternalGroupNodeListener m_groupNodeListener = new InternalGroupNodeListener();
    private final ListenerProvider<INaviGraphListener> m_listeners = new ListenerProvider();
    private final CEdgeDrawingSynchronizer m_edgeDrawingSynchronizer;
    private INaviView m_oldView;
    private final CGraphSettingsSynchronizer m_settingsSynchronizer;
    private boolean m_multiEdgeUpdatingEnabled = true;
    private final Map<INaviModule, Integer> m_cachedModuleListeners = new HashMap<INaviModule, Integer>();
    private final InternalModuleListener m_internalModuleListener = new InternalModuleListener();
    private final Map<CTag, Integer> m_cachedTagListeners = new HashMap<CTag, Integer>();
    private final InternalTagListener m_internalTagListener = new InternalTagListener();
    private final Set<NaviNode> m_selectedNodes = new HashSet<NaviNode>();

    public CViewGraphSynchronizer(ZyGraph zyGraph, IZyGraphInternals iZyGraphInternals, ZyGraphMappings<NaviNode, NaviEdge> zyGraphMappings) {
        this.m_graph = Preconditions.checkNotNull(zyGraph, "IE00981: Graph argument can not be null");
        this.m_graphInternals = Preconditions.checkNotNull(iZyGraphInternals, "IE00982: Graph internals argument can not be null");
        this.m_mappings = Preconditions.checkNotNull(zyGraphMappings, "IE00983: Mappings argument can not be null");
        this.m_oldView = zyGraph.getRawView();
        this.m_edgeDrawingSynchronizer = new CEdgeDrawingSynchronizer(zyGraph);
        this.m_settingsSynchronizer = new CGraphSettingsSynchronizer(zyGraph);
        for (NaviNode naviNode : zyGraphMappings.getNodes()) {
            if (!naviNode.isSelected()) continue;
            this.m_selectedNodes.add(naviNode);
        }
        this.initializeListeners();
    }

    private void addModuleListener(INaviFunctionNode iNaviFunctionNode) {
        INaviModule iNaviModule = iNaviFunctionNode.getFunction().getModule();
        if (!this.m_cachedModuleListeners.containsKey(iNaviModule)) {
            this.m_cachedModuleListeners.put(iNaviModule, 0);
            iNaviModule.addListener(this.m_internalModuleListener);
        }
        this.m_cachedModuleListeners.put(iNaviModule, this.m_cachedModuleListeners.get(iNaviModule) + 1);
    }

    private void addTagListener(CTag cTag) {
        if (!this.m_cachedTagListeners.containsKey(cTag)) {
            this.m_cachedTagListeners.put(cTag, 0);
            cTag.addListener(this.m_internalTagListener);
        }
        this.m_cachedTagListeners.put(cTag, this.m_cachedTagListeners.get(cTag) + 1);
    }

    private void initializeListeners() {
        this.m_graph.getRawView().addListener(this.m_viewListener);
        for (INaviViewNode iNaviViewNode : this.m_graph.getRawView().getGraph().getNodes()) {
            if (!(iNaviViewNode instanceof INaviGroupNode)) continue;
            ((INaviGroupNode)iNaviViewNode).addGroupListener(this.m_groupNodeListener);
        }
        for (INaviViewNode iNaviViewNode : this.m_graph.getRawView().getGraph()) {
            if (iNaviViewNode instanceof INaviFunctionNode) {
                this.addModuleListener((INaviFunctionNode)iNaviViewNode);
            }
            Iterator<CTag> iterator = iNaviViewNode.getTagsIterator();
            while (iterator.hasNext()) {
                this.addTagListener(iterator.next());
            }
        }
    }

    private void rebuildNode(NaviNode naviNode) {
        ((ZyNodeRealizer)this.m_graph.getGraph().t(naviNode.getNode())).regenerate();
    }

    private void removeEdge(INaviEdge iNaviEdge) {
        this.m_graphInternals.removeEdge((NaviEdge)this.m_graph.getEdge(iNaviEdge));
        this.m_edgeDrawingSynchronizer.updateEdgeDrawingState();
        this.m_graph.updateViews();
    }

    private void removeListeners(INaviView iNaviView) {
        iNaviView.removeListener(this.m_viewListener);
        for (INaviViewNode iNaviViewNode : iNaviView.getGraph().getNodes()) {
            if (!(iNaviViewNode instanceof INaviGroupNode)) continue;
            ((INaviGroupNode)iNaviViewNode).removeGroupListener(this.m_groupNodeListener);
        }
    }

    private void removeNode(NaviNode naviNode) {
        if (naviNode.getRawNode() instanceof INaviGroupNode) {
            ((INaviGroupNode)naviNode.getRawNode()).removeGroupListener(this.m_groupNodeListener);
        }
        this.m_selectedNodes.remove(naviNode);
        this.m_graphInternals.removeNode(naviNode);
        this.m_graph.updateViews();
    }

    private void updateMultiEdges() {
        if (this.m_multiEdgeUpdatingEnabled) {
            if (this.m_graph.getSettings().getEdgeSettings().getDisplayMultipleEdgesAsOne()) {
                MultiEdgeHider.hideMultipleEdgesInternal(this.m_graph);
            } else {
                MultiEdgeHider.unhideMultipleEdgesInternal(this.m_graph);
            }
        }
    }

    private void updateMultiEdges(IViewNode<?> iViewNode) {
        if (this.m_multiEdgeUpdatingEnabled) {
            if (this.m_graph.getSettings().getEdgeSettings().getDisplayMultipleEdgesAsOne()) {
                MultiEdgeHider.hideMultipleEdgesInternal(this.m_graph.getNode(iViewNode));
            } else {
                MultiEdgeHider.unhideMultipleEdgesInternal(this.m_graph);
            }
        }
    }

    private void updateParentNode(INaviViewNode iNaviViewNode, INaviGroupNode iNaviGroupNode) {
        p p2;
        p p3 = this.m_mappings.getYNode(iNaviViewNode);
        p p4 = p2 = iNaviGroupNode == null ? null : this.m_mappings.getYNode(iNaviGroupNode);
        if (p3 != null) {
            this.m_graph.getGraph().C().c(p3, p2);
            this.m_graph.updateViews();
        }
    }

    public void addListener(INaviGraphListener iNaviGraphListener) {
        this.m_listeners.addListener(iNaviGraphListener);
    }

    public void dispose() {
        this.removeListeners(this.m_graph.getRawView());
        this.m_edgeDrawingSynchronizer.dispose();
        this.m_settingsSynchronizer.dispose();
    }

    public Set<NaviNode> getSelectedNodes() {
        return new HashSet<NaviNode>(this.m_selectedNodes);
    }

    public void removeListener(INaviGraphListener iNaviGraphListener) {
        this.m_listeners.removeListener(iNaviGraphListener);
    }

    public void reset() {
        this.removeListeners(this.m_oldView);
        this.initializeListeners();
        this.m_oldView = this.m_graph.getRawView();
    }

    public void setMultiEdgeUpdatingEnabled(boolean bl2) {
        this.m_multiEdgeUpdatingEnabled = bl2;
        this.updateMultiEdges();
    }

    private class InternalViewListener
    extends CViewListenerAdapter {
        private InternalViewListener() {
        }

        private void deletedNodeImplementation(INaviViewNode iNaviViewNode) {
            CViewGraphSynchronizer.this.removeNode((NaviNode)CViewGraphSynchronizer.this.m_mappings.getNode(iNaviViewNode));
            if (CViewGraphSynchronizer.this.m_graph.getSettings().getLayoutSettings().getAutomaticLayouting() && this.isCollapsedGroupNode(iNaviViewNode)) {
                CViewGraphSynchronizer.this.m_graph.doLayout();
            }
            CViewGraphSynchronizer.this.m_graphInternals.notifyNodeDeleted();
        }

        private void deletedNodesImplementation(Iterable<INaviViewNode> iterable) {
            boolean bl2 = CViewGraphSynchronizer.this.m_graph.getSettings().getProximitySettings().getProximityBrowsing();
            boolean bl3 = false;
            for (INaviViewNode iNaviViewNode : iterable) {
                CViewGraphSynchronizer.this.removeNode((NaviNode)CViewGraphSynchronizer.this.m_mappings.getNode(iNaviViewNode));
                bl3 |= this.isCollapsedGroupNode(iNaviViewNode);
            }
            if (bl2) {
                CViewGraphSynchronizer.this.m_graph.getSettings().getProximitySettings().setProximityBrowsing(bl2);
            }
            if (CViewGraphSynchronizer.this.m_graph.getSettings().getLayoutSettings().getAutomaticLayouting() && bl3) {
                CViewGraphSynchronizer.this.m_graph.doLayout();
            }
            CViewGraphSynchronizer.this.m_graphInternals.notifyNodeDeleted();
        }

        private boolean isCollapsedGroupNode(INaviViewNode iNaviViewNode) {
            return iNaviViewNode instanceof INaviGroupNode && ((INaviGroupNode)iNaviViewNode).isCollapsed();
        }

        private void setupNewEdge(INaviEdge iNaviEdge) {
            Preconditions.checkNotNull(CViewGraphSynchronizer.this.m_graph.getYNode(iNaviEdge.getSource()), "Unknown source node");
            Preconditions.checkNotNull(CViewGraphSynchronizer.this.m_graph.getYNode(iNaviEdge.getTarget()), String.format("Unknown target node '%s'", iNaviEdge.getTarget()));
            ((INaviViewNode)iNaviEdge.getSource()).setVisible(true);
            ((INaviViewNode)iNaviEdge.getTarget()).setVisible(true);
            Pair<d, NaviEdge> pair = ZyEdgeBuilder.convertEdge(iNaviEdge, (NaviNode)CViewGraphSynchronizer.this.m_mappings.getNode(iNaviEdge.getSource()), (NaviNode)CViewGraphSynchronizer.this.m_mappings.getNode(iNaviEdge.getTarget()), CViewGraphSynchronizer.this.m_graph.getGraph(), true);
            ZyEdgeRealizer zyEdgeRealizer = (ZyEdgeRealizer)CViewGraphSynchronizer.this.m_graph.getGraph().i(pair.first());
            zyEdgeRealizer.setDrawBends(CViewGraphSynchronizer.this.m_graph.getSettings().getEdgeSettings().getDrawSelectedBends());
            zyEdgeRealizer.setDrawSloppyEdges(CEdgeDrawingFunctions.calcDrawSloppyEdges(CViewGraphSynchronizer.this.m_graph));
            CViewGraphSynchronizer.this.m_mappings.addEdge(pair.first(), (ZyGraphEdge)pair.second());
            CViewGraphSynchronizer.this.m_edgeDrawingSynchronizer.updateEdgeDrawingState();
        }

        private void setupNewNode(INaviViewNode iNaviViewNode) {
            Pair<p, NaviNode> pair = ZyGraphNodeBuilder.convertNode(iNaviViewNode, CViewGraphSynchronizer.this.m_graph.getGraph(), CViewGraphSynchronizer.this.m_graph.getSettings());
            CViewGraphSynchronizer.this.m_mappings.addNode(pair.first(), (ZyGraphNode)pair.second());
            if (iNaviViewNode instanceof INaviGroupNode) {
                ((INaviGroupNode)iNaviViewNode).addGroupListener(CViewGraphSynchronizer.this.m_groupNodeListener);
            }
            for (INaviGraphListener iNaviGraphListener : CViewGraphSynchronizer.this.m_listeners) {
                try {
                    iNaviGraphListener.addedNode(CViewGraphSynchronizer.this.m_graph, pair.second());
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void addedEdge(INaviView iNaviView, INaviEdge iNaviEdge) {
            this.setupNewEdge(iNaviEdge);
        }

        @Override
        public void addedNode(INaviView iNaviView, final INaviViewNode iNaviViewNode) {
            if (iNaviViewNode instanceof INaviFunctionNode) {
                CViewGraphSynchronizer.this.addModuleListener((INaviFunctionNode)iNaviViewNode);
            }
            if (iNaviViewNode.isSelected()) {
                CViewGraphSynchronizer.this.m_selectedNodes.add(CViewGraphSynchronizer.this.m_mappings.getNode(iNaviViewNode));
            }
            new SwingInvoker(){

                @Override
                protected void operation() {
                    InternalViewListener.this.setupNewNode(iNaviViewNode);
                }
            }.invokeAndWait();
            if (iNaviViewNode instanceof INaviGroupNode) {
                INaviGroupNode iNaviGroupNode = (INaviGroupNode)iNaviViewNode;
                for (INaviViewNode iNaviViewNode2 : iNaviGroupNode.getElements()) {
                    CViewGraphSynchronizer.this.updateParentNode(iNaviViewNode2, iNaviGroupNode);
                }
            }
        }

        @Override
        public void appendedGlobalEdgeComment(INaviView iNaviView, INaviEdge iNaviEdge) {
            ((ZyEdgeRealizer)CViewGraphSynchronizer.this.m_graph.getGraph().i(((NaviEdge)CViewGraphSynchronizer.this.m_graph.getEdge(iNaviEdge)).getEdge())).regenerate();
        }

        @Override
        public void appendedLocalEdgeComment(INaviView iNaviView, INaviEdge iNaviEdge) {
            ((ZyEdgeRealizer)CViewGraphSynchronizer.this.m_graph.getGraph().i(((NaviEdge)CViewGraphSynchronizer.this.m_graph.getEdge(iNaviEdge)).getEdge())).regenerate();
        }

        @Override
        public void appendedLocalFunctionNodeComment(INaviView iNaviView, INaviFunctionNode iNaviFunctionNode, IComment iComment) {
            CViewGraphSynchronizer.this.rebuildNode((NaviNode)CViewGraphSynchronizer.this.m_graph.getNode(iNaviFunctionNode));
        }

        @Override
        public void changedParentGroup(INaviView iNaviView, INaviViewNode iNaviViewNode, INaviGroupNode iNaviGroupNode) {
            CViewGraphSynchronizer.this.updateParentNode(iNaviViewNode, iNaviGroupNode);
        }

        @Override
        public void changedSelection(INaviView iNaviView, IViewNode<?> iViewNode, boolean bl2) {
            for (IViewEdge iViewEdge : iViewNode.getIncomingEdges()) {
                iViewEdge.setSelected(bl2 || ((IViewNode)iViewEdge.getSource()).isSelected());
            }
            for (IViewEdge iViewEdge : iViewNode.getOutgoingEdges()) {
                iViewEdge.setSelected(bl2 || ((IViewNode)iViewEdge.getTarget()).isSelected());
            }
            if (bl2) {
                CViewGraphSynchronizer.this.m_selectedNodes.add(CViewGraphSynchronizer.this.m_graph.getNode(iViewNode));
            } else {
                CViewGraphSynchronizer.this.m_selectedNodes.remove(CViewGraphSynchronizer.this.m_graph.getNode(iViewNode));
            }
        }

        @Override
        public void changedVisibility(INaviView iNaviView, IViewEdge<?> iViewEdge) {
            CViewGraphSynchronizer.this.m_edgeDrawingSynchronizer.updateEdgeDrawingState();
            NaviEdge naviEdge = (NaviEdge)CViewGraphSynchronizer.this.m_mappings.getEdge(iViewEdge);
            if (iViewEdge != null) {
                naviEdge.getRealizer().setDrawSloppyEdges(CEdgeDrawingFunctions.calcDrawSloppyEdges(CViewGraphSynchronizer.this.m_graph));
            }
        }

        @Override
        public void changedVisibility(INaviView iNaviView, IViewNode<?> iViewNode, boolean bl2) {
            CViewGraphSynchronizer.this.updateMultiEdges(iViewNode);
        }

        @Override
        public void closedView(INaviView iNaviView, IDirectedGraph<INaviViewNode, INaviEdge> iDirectedGraph) {
        }

        @Override
        public boolean closingView(INaviView iNaviView) {
            return true;
        }

        @Override
        public void deletedEdge(INaviView iNaviView, INaviEdge iNaviEdge) {
            CViewGraphSynchronizer.this.removeEdge(iNaviEdge);
        }

        @Override
        public void deletedGlobalEdgeComment(INaviView iNaviView, INaviEdge iNaviEdge) {
            ((ZyEdgeRealizer)CViewGraphSynchronizer.this.m_graph.getGraph().i(((NaviEdge)CViewGraphSynchronizer.this.m_graph.getEdge(iNaviEdge)).getEdge())).regenerate();
        }

        @Override
        public void deletedLocalEdgeComment(INaviView iNaviView, INaviEdge iNaviEdge) {
            ((ZyEdgeRealizer)CViewGraphSynchronizer.this.m_graph.getGraph().i(((NaviEdge)CViewGraphSynchronizer.this.m_graph.getEdge(iNaviEdge)).getEdge())).regenerate();
        }

        @Override
        public void deletedLocalFunctionNodeComment(INaviView iNaviView, INaviFunctionNode iNaviFunctionNode, IComment iComment) {
        }

        @Override
        public void deletedNode(INaviView iNaviView, final INaviViewNode iNaviViewNode) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    InternalViewListener.this.deletedNodeImplementation(iNaviViewNode);
                }
            }.invokeAndWait();
        }

        @Override
        public void deletedNodes(INaviView iNaviView, final Collection<INaviViewNode> collection) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    InternalViewListener.this.deletedNodesImplementation(collection);
                }
            }.invokeAndWait();
        }

        @Override
        public void editedGlobalEdgeComment(INaviView iNaviView, INaviEdge iNaviEdge) {
            ((ZyEdgeRealizer)CViewGraphSynchronizer.this.m_graph.getGraph().i(((NaviEdge)CViewGraphSynchronizer.this.m_graph.getEdge(iNaviEdge)).getEdge())).regenerate();
        }

        @Override
        public void editedLocalEdgeComment(INaviView iNaviView, INaviEdge iNaviEdge) {
            ((ZyEdgeRealizer)CViewGraphSynchronizer.this.m_graph.getGraph().i(((NaviEdge)CViewGraphSynchronizer.this.m_graph.getEdge(iNaviEdge)).getEdge())).regenerate();
        }

        @Override
        public void editedLocalFunctionNodeComment(INaviView iNaviView, INaviFunctionNode iNaviFunctionNode, IComment iComment) {
        }

        @Override
        public void taggedNode(INaviView iNaviView, final INaviViewNode iNaviViewNode, CTag cTag) {
            CViewGraphSynchronizer.this.m_graph.iterate(new INodeCallback<NaviNode>(){

                @Override
                public IterationMode next(NaviNode naviNode) {
                    INaviViewNode iNaviViewNode2 = naviNode.getRawNode();
                    if (iNaviViewNode2.equals(iNaviViewNode)) {
                        CViewGraphSynchronizer.this.rebuildNode(naviNode);
                    }
                    return IterationMode.CONTINUE;
                }
            });
            CViewGraphSynchronizer.this.addTagListener(cTag);
            for (INaviGraphListener iNaviGraphListener : CViewGraphSynchronizer.this.m_listeners) {
                try {
                    iNaviGraphListener.taggedNode(CViewGraphSynchronizer.this.m_graph.getRawView(), iNaviViewNode, cTag);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void untaggedNodes(INaviView iNaviView, final INaviViewNode iNaviViewNode, List<CTag> list) {
            CViewGraphSynchronizer.this.m_graph.iterate(new INodeCallback<NaviNode>(){

                @Override
                public IterationMode next(NaviNode naviNode) {
                    INaviViewNode iNaviViewNode2 = naviNode.getRawNode();
                    if (iNaviViewNode2.equals(iNaviViewNode)) {
                        CViewGraphSynchronizer.this.rebuildNode(naviNode);
                    }
                    return IterationMode.CONTINUE;
                }
            });
            for (INaviGraphListener iNaviGraphListener : CViewGraphSynchronizer.this.m_listeners) {
                for (CTag cTag : list) {
                    try {
                        iNaviGraphListener.untaggedNode(CViewGraphSynchronizer.this.m_graph.getRawView(), iNaviViewNode, cTag);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }
    }

    private class InternalTagListener
    implements ITagListener {
        private InternalTagListener() {
        }

        @Override
        public void changedDescription(final CTag cTag, String string2) {
            CViewGraphSynchronizer.this.m_graph.iterate(new INodeCallback<NaviNode>(){

                @Override
                public IterationMode next(NaviNode naviNode) {
                    INaviViewNode iNaviViewNode = naviNode.getRawNode();
                    if (iNaviViewNode.isTagged(cTag)) {
                        CViewGraphSynchronizer.this.rebuildNode(naviNode);
                    }
                    return IterationMode.CONTINUE;
                }
            });
        }

        @Override
        public void changedName(final CTag cTag, String string2) {
            CViewGraphSynchronizer.this.m_graph.iterate(new INodeCallback<NaviNode>(){

                @Override
                public IterationMode next(NaviNode naviNode) {
                    INaviViewNode iNaviViewNode = naviNode.getRawNode();
                    if (iNaviViewNode.isTagged(cTag)) {
                        CViewGraphSynchronizer.this.rebuildNode(naviNode);
                    }
                    return IterationMode.CONTINUE;
                }
            });
        }

        @Override
        public void deletedTag(CTag cTag) {
        }
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void changedName(final INaviModule iNaviModule, String string2) {
            CViewGraphSynchronizer.this.m_graph.iterate(new INodeCallback<NaviNode>(){

                @Override
                public IterationMode next(NaviNode naviNode) {
                    INaviFunctionNode iNaviFunctionNode;
                    INaviViewNode iNaviViewNode = naviNode.getRawNode();
                    if (iNaviViewNode instanceof INaviFunctionNode && (iNaviFunctionNode = (INaviFunctionNode)iNaviViewNode).getFunction().getModule().equals(iNaviModule)) {
                        CViewGraphSynchronizer.this.rebuildNode(naviNode);
                    }
                    return IterationMode.CONTINUE;
                }
            });
        }
    }

    private class InternalGroupNodeListener
    extends CNaviGroupNodeListenerAdapter {
        private InternalGroupNodeListener() {
        }

        @Override
        public void changedState(INaviGroupNode iNaviGroupNode) {
            if (iNaviGroupNode.isCollapsed()) {
                YHelpers.closeGroup(CViewGraphSynchronizer.this.m_graph.getGraph(), ((NaviNode)CViewGraphSynchronizer.this.m_mappings.getNode(iNaviGroupNode)).getNode());
            } else {
                YHelpers.openFolder(CViewGraphSynchronizer.this.m_graph.getGraph(), ((NaviNode)CViewGraphSynchronizer.this.m_mappings.getNode(iNaviGroupNode)).getNode());
            }
            if (CViewGraphSynchronizer.this.m_graph.getSettings().getLayoutSettings().getAutomaticLayouting()) {
                CViewGraphSynchronizer.this.m_graph.doLayout();
            }
        }
    }
}

